/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockLightBulb
extends Block {
    protected BlockLightBulb(int i2) {
        super(i2, Material.glass);
        this.blockIndexInTexture = i2 + 5;
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public void onBlockAdded(World world, int a2, int b2, int c2) {
        super.onBlockAdded(world, a2, b2, c2);
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        boolean power = this.isReceivingRedstonePower(world, i2, j2, k2, l2);
        if (power) {
            world.setBlock(i2, j2, k2, 98);
        } else {
            world.setBlock(i2, j2, k2, 97);
        }
    }

    public int idDropped(int i2, Random random) {
        return Block.lightBulb.blockID;
    }

    public static boolean isPowered(int i2) {
        return (i2 & 8) != 0;
    }

    public void updateTick(World world, int a2, int b2, int c2, Random random) {
        super.updateTick(world, a2, b2, c2, random);
    }

    private boolean isReceivingRedstonePower(World world, int i2, int j2, int k2, int l2) {
        if (l2 != 0 && world.isBlockIndirectlyProvidingPowerTo(i2, j2 - 1, k2, 0)) {
            return true;
        }
        if (l2 != 1 && world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 1, k2, 1)) {
            return true;
        }
        if (l2 != 2 && world.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 - 1, 2)) {
            return true;
        }
        if (l2 != 3 && world.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 + 1, 3)) {
            return true;
        }
        if (l2 != 5 && world.isBlockIndirectlyProvidingPowerTo(i2 + 1, j2, k2, 5)) {
            return true;
        }
        if (l2 != 4 && world.isBlockIndirectlyProvidingPowerTo(i2 - 1, j2, k2, 4)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2, k2, 0)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 2, k2, 1)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 1, k2 - 1, 2)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 1, k2 + 1, 3)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2 - 1, j2 + 1, k2, 4)) {
            return true;
        }
        return world.isBlockIndirectlyProvidingPowerTo(i2 + 1, j2 + 1, k2, 5);
    }

    public void dropBlockAsItemWithChance(World world, int a2, int b2, int c2, int bid) {
        super.dropBlockAsItemWithChance(world, a2, b2, c2, bid);
    }
}

