/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockGrass
extends Block {
    private boolean goldCheck;

    protected BlockGrass(int i2) {
        super(i2, Material.ground);
        this.blockIndexInTexture = 3;
        this.setTickOnLoad(true);
    }

    public int getTextureIndex(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        if (l2 == 1) {
            return 0;
        }
        if (l2 == 0) {
            return 2;
        }
        Material material = iblockaccess.getMaterialXYZ(i2, j2 + 1, k2);
        return material != Material.snow && material != Material.builtSnow ? 3 : 68;
    }

    public int getTextureIndex(int i2) {
        if (i2 == 1) {
            return 0;
        }
        if (i2 == 0) {
            return 2;
        }
        return this.blockIndexInTexture;
    }

    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        int j1;
        int i1;
        int l2;
        if (world.multiplayerWorld) {
            return;
        }
        if (world.getBlockLightValue(i2, j2 + 1, k2) < 4 && world.getMaterialXYZ(i2, j2 + 1, k2).func_881_b()) {
            if (random.nextInt(4) != 0) {
                return;
            }
            world.setBlockWithNotify(i2, j2, k2, Block.dirt.blockID);
        } else if (world.getBlockLightValue(i2, j2 + 1, k2) >= 9 && world.getBlockId(l2 = i2 + random.nextInt(3) - 1, i1 = j2 + random.nextInt(5) - 3, j1 = k2 + random.nextInt(3) - 1) == Block.dirt.blockID && world.getBlockLightValue(l2, i1 + 1, j1) >= 4 && !world.getMaterialXYZ(l2, i1 + 1, j1).func_881_b()) {
            world.setBlockWithNotify(l2, i1, j1, Block.grass.blockID);
        }
    }

    public void goldTouch() {
        this.goldCheck = true;
        System.out.println("I AM GOLD");
    }

    public void notGoldTouch() {
        this.goldCheck = false;
    }

    public int idDropped(int i2, Random random) {
        if (this.goldCheck) {
            return Block.grass.blockID;
        }
        return Block.dirt.idDropped(0, random);
    }
}

