/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFlower;
import java.util.Random;

public class BlockCrops
extends BlockFlower {
    protected BlockCrops(int i2, int j2) {
        super(i2, j2);
        this.blockIndexInTexture = j2;
        this.setTickOnLoad(true);
        float f2 = 0.5f;
        this.setBlockBounds(0.5f - f2, 0.0f, 0.5f - f2, 0.5f + f2, 0.25f, 0.5f + f2);
    }

    protected boolean canThisPlantGrowOnThisBlockID(int i2) {
        return i2 == Block.tilledField.blockID;
    }

    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        float f2;
        int l2;
        super.updateTick(world, i2, j2, k2, random);
        if (world.getBlockLightValue(i2, j2 + 1, k2) >= 9 && (l2 = world.getBlockMetadata(i2, j2, k2)) < 7 && random.nextInt((int)(100.0f / (f2 = this.getGrowthRate(world, i2, j2, k2)))) == 0) {
            world.setBlockMetadataWithNotify(i2, j2, k2, ++l2);
        }
    }

    public void fertilize(World world, int i2, int j2, int k2) {
        world.setBlockMetadataWithNotify(i2, j2, k2, 7);
    }

    private float getGrowthRate(World world, int i2, int j2, int k2) {
        float f2 = 1.0f;
        int l2 = world.getBlockId(i2, j2, k2 - 1);
        int i1 = world.getBlockId(i2, j2, k2 + 1);
        int j1 = world.getBlockId(i2 - 1, j2, k2);
        int k1 = world.getBlockId(i2 + 1, j2, k2);
        int l1 = world.getBlockId(i2 - 1, j2, k2 - 1);
        int i22 = world.getBlockId(i2 + 1, j2, k2 - 1);
        int j22 = world.getBlockId(i2 + 1, j2, k2 + 1);
        int k22 = world.getBlockId(i2 - 1, j2, k2 + 1);
        boolean flag = j1 == this.blockID || k1 == this.blockID;
        boolean flag1 = l2 == this.blockID || i1 == this.blockID;
        boolean flag2 = l1 == this.blockID || i22 == this.blockID || j22 == this.blockID || k22 == this.blockID;
        int l22 = i2 - 1;
        while (l22 <= i2 + 1) {
            int i3 = k2 - 1;
            while (i3 <= k2 + 1) {
                int j3 = world.getBlockId(l22, j2 - 1, i3);
                float f1 = 0.0f;
                if (j3 == Block.tilledField.blockID) {
                    f1 = 1.0f;
                    if (world.getBlockMetadata(l22, j2 - 1, i3) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (l22 != i2 || i3 != k2) {
                    f1 /= 4.0f;
                }
                f2 += f1;
                ++i3;
            }
            ++l22;
        }
        if (flag2 || flag && flag1) {
            f2 /= 2.0f;
        }
        return f2;
    }

    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        if (j2 < 0) {
            j2 = 7;
        }
        return this.blockIndexInTexture + j2;
    }

    public int getRenderType() {
        return 6;
    }

    public void dropBlockAsItemWithChance(World world, int i2, int j2, int k2, int l2) {
        super.dropBlockAsItemWithChance(world, i2, j2, k2, l2);
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = 0;
        while (i1 < 3) {
            if (world.rand.nextInt(15) <= l2) {
                float f2 = 0.7f;
                float f1 = world.rand.nextFloat() * f2 + (1.0f - f2) * 0.5f;
                float f22 = world.rand.nextFloat() * f2 + (1.0f - f2) * 0.5f;
                float f3 = world.rand.nextFloat() * f2 + (1.0f - f2) * 0.5f;
                EntityItem entityitem = new EntityItem(world, (float)i2 + f1, (float)j2 + f22, (float)k2 + f3, new ItemStack(Item.seeds));
                entityitem.delayBeforeCanPickup = 10;
                world.entityJoinedWorld(entityitem);
            }
            ++i1;
        }
    }

    public void dropBlockAsItemWithChance(World world, int i2, int j2, int k2, int l2, float f2) {
        super.dropBlockAsItemWithChance(world, i2, j2, k2, l2, f2);
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = 0;
        while (i1 < 3) {
            if (world.rand.nextInt(15) <= l2) {
                float f1 = 0.7f;
                float f22 = world.rand.nextFloat() * f1 + (1.0f - f1) * 0.5f;
                float f3 = world.rand.nextFloat() * f1 + (1.0f - f1) * 0.5f;
                float f4 = world.rand.nextFloat() * f1 + (1.0f - f1) * 0.5f;
                EntityItem entityitem = new EntityItem(world, (float)i2 + f22, (float)j2 + f3, (float)k2 + f4, new ItemStack(Item.seeds));
                entityitem.delayBeforeCanPickup = 10;
                world.entityJoinedWorld(entityitem);
            }
            ++i1;
        }
    }

    public int idDropped(int i2, Random random) {
        System.out.println("Get resource: " + i2);
        if (i2 == 7) {
            return Item.wheat.shiftedIndex;
        }
        return -1;
    }

    public int quantityDropped(Random random) {
        return 1;
    }
}

