/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.region;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class RegionFile {
    static final int CHUNK_HEADER_SIZE = 5;
    private static final byte[] emptySector = new byte[4096];
    private final File file;
    private RandomAccessFile dataFile;
    private final int[] offsets = new int[1024];
    private ArrayList<Boolean> sectorFree;
    private int sizeDelta;
    private long lastModified = 0L;

    public RegionFile(File path) {
        this.file = path;
        this.debugln("REGION LOAD " + this.file);
        this.sizeDelta = 0;
        try {
            int i2;
            if (path.exists()) {
                this.lastModified = path.lastModified();
            }
            this.dataFile = new RandomAccessFile(path, "rw");
            if (this.dataFile.length() < 4096L) {
                i2 = 0;
                while (i2 < 1024) {
                    this.dataFile.writeInt(0);
                    ++i2;
                }
                i2 = 0;
                while (i2 < 1024) {
                    this.dataFile.writeInt(0);
                    ++i2;
                }
                this.sizeDelta += 4096;
            }
            if ((this.dataFile.length() & 0xFFFL) != 0L) {
                i2 = 0;
                while ((long)i2 < (this.dataFile.length() & 0xFFFL)) {
                    this.dataFile.write(0);
                    ++i2;
                }
            }
            int nSectors = (int)this.dataFile.length() / 4096;
            this.sectorFree = new ArrayList(nSectors);
            int i3 = 0;
            while (i3 < nSectors) {
                this.sectorFree.add(true);
                ++i3;
            }
            this.sectorFree.set(0, false);
            this.sectorFree.set(1, false);
            this.dataFile.seek(0L);
            i3 = 0;
            while (i3 < 1024) {
                int offset;
                this.offsets[i3] = offset = this.dataFile.readInt();
                if (offset != 0 && (offset >> 8) + (offset & 0xFF) <= this.sectorFree.size()) {
                    int sectorNum = 0;
                    while (sectorNum < (offset & 0xFF)) {
                        this.sectorFree.set((offset >> 8) + sectorNum, false);
                        ++sectorNum;
                    }
                }
                ++i3;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public long lastModified() {
        return this.lastModified;
    }

    public synchronized int getSizeDelta() {
        int ret = this.sizeDelta;
        this.sizeDelta = 0;
        return ret;
    }

    private void debug(String in2) {
    }

    private void debugln(String in2) {
        this.debug(String.valueOf(in2) + "\n");
    }

    private void debug(String mode, int x2, int z2, String in2) {
        this.debug("REGION " + mode + " " + this.file.getName() + "[" + x2 + "," + z2 + "] = " + in2);
    }

    private void debug(String mode, int x2, int z2, int count, String in2) {
        this.debug("REGION " + mode + " " + this.file.getName() + "[" + x2 + "," + z2 + "] " + count + "B = " + in2);
    }

    private void debugln(String mode, int x2, int z2, String in2) {
        this.debug(mode, x2, z2, String.valueOf(in2) + "\n");
    }

    public synchronized DataInputStream getChunkDataInputStream(int x2, int z2) {
        int length;
        block10: {
            int numSectors;
            int sectorNumber;
            block9: {
                int offset;
                block8: {
                    if (this.outOfBounds(x2, z2)) {
                        this.debugln("READ", x2, z2, "out of bounds");
                        return null;
                    }
                    try {
                        offset = this.getOffset(x2, z2);
                        if (offset != 0) break block8;
                        return null;
                    }
                    catch (IOException e2) {
                        this.debugln("READ", x2, z2, "exception");
                        return null;
                    }
                }
                sectorNumber = offset >> 8;
                numSectors = offset & 0xFF;
                if (sectorNumber + numSectors <= this.sectorFree.size()) break block9;
                this.debugln("READ", x2, z2, "invalid sector");
                return null;
            }
            this.dataFile.seek(sectorNumber * 4096);
            length = this.dataFile.readInt();
            if (length <= 4096 * numSectors) break block10;
            this.debugln("READ", x2, z2, "invalid length: " + length + " > 4096 * " + numSectors);
            return null;
        }
        byte version = this.dataFile.readByte();
        if (version == 1) {
            byte[] data = new byte[length - 1];
            this.dataFile.read(data);
            DataInputStream ret = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(data)));
            return ret;
        }
        if (version == 2) {
            byte[] data = new byte[length - 1];
            this.dataFile.read(data);
            DataInputStream ret = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(data)));
            return ret;
        }
        this.debugln("READ", x2, z2, "unknown version " + version);
        return null;
    }

    public DataOutputStream getChunkDataOutputStream(int x2, int z2) {
        if (this.outOfBounds(x2, z2)) {
            return null;
        }
        return new DataOutputStream(new DeflaterOutputStream(new ChunkBuffer(x2, z2)));
    }

    protected synchronized void write(int x2, int z2, byte[] data, int length) {
        try {
            int offset = this.getOffset(x2, z2);
            int sectorNumber = offset >> 8;
            int sectorsAllocated = offset & 0xFF;
            int sectorsNeeded = (length + 5) / 4096 + 1;
            if (sectorsNeeded >= 256) {
                return;
            }
            if (sectorNumber != 0 && sectorsAllocated == sectorsNeeded) {
                this.debug("SAVE", x2, z2, length, "rewrite");
                this.write(sectorNumber, data, length);
            } else {
                int i2;
                int i3 = 0;
                while (i3 < sectorsAllocated) {
                    this.sectorFree.set(sectorNumber + i3, true);
                    ++i3;
                }
                int runStart = this.sectorFree.indexOf(true);
                int runLength = 0;
                if (runStart != -1) {
                    i2 = runStart;
                    while (i2 < this.sectorFree.size()) {
                        if (runLength != 0) {
                            runLength = this.sectorFree.get(i2).booleanValue() ? ++runLength : 0;
                        } else if (this.sectorFree.get(i2).booleanValue()) {
                            runStart = i2;
                            runLength = 1;
                        }
                        if (runLength >= sectorsNeeded) break;
                        ++i2;
                    }
                }
                if (runLength >= sectorsNeeded) {
                    this.debug("SAVE", x2, z2, length, "reuse");
                    sectorNumber = runStart;
                    this.setOffset(x2, z2, sectorNumber << 8 | sectorsNeeded);
                    i2 = 0;
                    while (i2 < sectorsNeeded) {
                        this.sectorFree.set(sectorNumber + i2, false);
                        ++i2;
                    }
                    this.write(sectorNumber, data, length);
                } else {
                    this.debug("SAVE", x2, z2, length, "grow");
                    this.dataFile.seek(this.dataFile.length());
                    sectorNumber = this.sectorFree.size();
                    i2 = 0;
                    while (i2 < sectorsNeeded) {
                        this.dataFile.write(emptySector);
                        this.sectorFree.add(false);
                        ++i2;
                    }
                    this.sizeDelta += 4096 * sectorsNeeded;
                    this.write(sectorNumber, data, length);
                    this.setOffset(x2, z2, sectorNumber << 8 | sectorsNeeded);
                }
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void write(int sectorNumber, byte[] data, int length) throws IOException {
        this.debugln(" " + sectorNumber);
        this.dataFile.seek(sectorNumber * 4096);
        this.dataFile.writeInt(length + 1);
        this.dataFile.writeByte(2);
        this.dataFile.write(data, 0, length);
    }

    private boolean outOfBounds(int x2, int z2) {
        return x2 < 0 || x2 >= 32 || z2 < 0 || z2 >= 32;
    }

    private int getOffset(int x2, int z2) throws IOException {
        return this.offsets[x2 + z2 * 32];
    }

    private void setOffset(int x2, int z2, int offset) throws IOException {
        this.offsets[x2 + z2 * 32] = offset;
        this.dataFile.seek((x2 + z2 * 32) * 4);
        this.dataFile.writeInt(offset);
    }

    public void close() throws IOException {
        this.dataFile.close();
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private int x;
        private int z;

        public ChunkBuffer(int x2, int z2) {
            super(8096);
            this.x = x2;
            this.z = z2;
        }

        public void close() {
            RegionFile.this.write(this.x, this.z, this.buf, this.count);
        }
    }
}

