/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.generate;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.Random;

public class WorldGenClay
extends WorldGenerator {
    private ArrayList<Integer> blockIds;
    private int clayBlockId;
    private int numberOfBlocks;

    public WorldGenClay(int i2) {
        this.clayBlockId = Block.blockClay.blockID;
        this.numberOfBlocks = i2;
        this.blockIds = new ArrayList();
        this.blockIds.add(Block.gravel.blockID);
        this.blockIds.add(Block.sand.blockID);
    }

    public WorldGenClay(int i2, int[] b2) {
        this.clayBlockId = Block.blockClay.blockID;
        this.numberOfBlocks = i2;
        this.blockIds = new ArrayList();
        int x2 = 0;
        while (x2 < b2.length) {
            this.blockIds.add(b2[x2]);
            ++x2;
        }
    }

    public boolean generate(World world, Random random, int i2, int j2, int k2) {
        if (world.getMaterialXYZ(i2, j2, k2) != Material.sand) {
            return false;
        }
        float f2 = random.nextFloat() * 3.141593f;
        double d2 = (float)(i2 + 8) + MathHelper.sin(f2) * (float)this.numberOfBlocks / 8.0f;
        double d1 = (float)(i2 + 8) - MathHelper.sin(f2) * (float)this.numberOfBlocks / 8.0f;
        double d22 = (float)(k2 + 8) + MathHelper.cos(f2) * (float)this.numberOfBlocks / 8.0f;
        double d3 = (float)(k2 + 8) - MathHelper.cos(f2) * (float)this.numberOfBlocks / 8.0f;
        double d4 = j2 + random.nextInt(3) + 2;
        double d5 = j2 + random.nextInt(3) + 2;
        int l2 = 0;
        while (l2 <= this.numberOfBlocks) {
            double d6 = d2 + (d1 - d2) * (double)l2 / (double)this.numberOfBlocks;
            double d7 = d4 + (d5 - d4) * (double)l2 / (double)this.numberOfBlocks;
            double d8 = d22 + (d3 - d22) * (double)l2 / (double)this.numberOfBlocks;
            double d9 = random.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.sin((float)l2 * 3.141593f / (float)this.numberOfBlocks) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.sin((float)l2 * 3.141593f / (float)this.numberOfBlocks) + 1.0f) * d9 + 1.0;
            double i1 = d6 - d10 / 2.0;
            while (i1 <= d6 + d10 / 2.0) {
                double j1 = d7 - d11 / 2.0;
                while (j1 <= d7 + d11 / 2.0) {
                    double k1 = d8 - d10 / 2.0;
                    while (k1 <= d8 + d10 / 2.0) {
                        int l1;
                        double d14;
                        double d13;
                        double d12 = (Math.floor(i1) + 0.5 - d6) / (d10 / 2.0);
                        if (!(d12 * d12 + (d13 = (Math.floor(j1) + 0.5 - d7) / (d11 / 2.0)) * d13 + (d14 = (Math.floor(k1) + 0.5 - d8) / (d10 / 2.0)) * d14 >= 100.0) && this.blockIds.contains(l1 = world.getBlockId((int)Math.floor(i1), (int)Math.floor(j1), (int)Math.floor(k1)))) {
                            world.setBlock((int)Math.floor(i1), (int)Math.floor(j1), (int)Math.floor(k1), this.clayBlockId);
                        }
                        k1 += 1.0;
                    }
                    j1 += 1.0;
                }
                i1 += 1.0;
            }
            ++l2;
        }
        return true;
    }
}

