/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.MinecraftException;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityGiant;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.Explosion;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.path.PathEntity;
import com.mojang.minecraft.entity.path.Pathfinder;
import com.mojang.minecraft.entity.tile.GearGroup;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityGear;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.NextTickListEntry;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.chunk.ChunkCache;
import com.mojang.minecraft.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.level.chunk.ChunkLoader;
import com.mojang.minecraft.level.chunk.ChunkProviderCorruption;
import com.mojang.minecraft.level.chunk.ChunkProviderDesert;
import com.mojang.minecraft.level.chunk.ChunkProviderGenerate;
import com.mojang.minecraft.level.chunk.ChunkProviderIndev;
import com.mojang.minecraft.level.chunk.ChunkProviderLoadOrGenerate;
import com.mojang.minecraft.level.chunk.ChunkProviderSky;
import com.mojang.minecraft.level.chunk.MetadataChunkBlock;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.region.RegionFileCache;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFluids;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.render.IWorldAccess;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.CompressedStreamTools;
import com.mojang.minecraft.util.MathHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class World
implements IBlockAccess {
    public static final int NORMAL = 0;
    public static final int FLOATING = 1;
    public static final int CORRUPTION = 2;
    public static final int DESERT = 3;
    public static final int INDEV = 4;
    public static final HashMap<Integer, String> TYPENAMES = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, "NORMAL");
            this.put(1, "FLOATING");
            this.put(2, "CORRUPTION");
            this.put(3, "DESERT");
            this.put(4, "2D PERLIN");
        }
    };
    public float cloudHeight = 108.0f;
    private List<MetadataChunkBlock> field_1025_z;
    public List<Entity> loadedEntityList;
    private List<Object> unloadedEntityList;
    private TreeSet<NextTickListEntry> field_1023_B;
    private Set<NextTickListEntry> field_1022_C;
    public List<Object> field_1049_b;
    public long worldTime;
    public boolean snowCovered;
    private long field_1021_D;
    private long field_1020_E;
    private long field_1019_F;
    public int skyLightSubtracted;
    protected int field_1045_f;
    protected int field_1044_g;
    public boolean etitingBlocks;
    public static float[] field_1042_i = new float[16];
    private final long field_1018_G;
    protected int saveRate;
    public List<EntityPlayer> playerEntities;
    public List<Entity> weatherEffects;
    public int difficulty;
    public Object field_1038_m;
    public Random rand;
    public int spawnX;
    public int spawnY;
    public int spawnZ;
    public boolean isNewWorld;
    protected List<IWorldAccess> worldAccesses;
    public IChunkProvider chunkProvider;
    public File worldFolder;
    public long randomSeed;
    private NBTTagCompound nbtCompoundPlayer;
    public long sizeOnDisk;
    public final String field_1028_w;
    public boolean field_1027_x;
    private ArrayList<AxisAlignedBB> field_1015_J;
    private Set<ChunkCoordIntPair> setOfTickableChunks;
    private int ambienceChance;
    private List<Entity> field_1012_M;
    public boolean multiplayerWorld;
    public boolean cheatsDisabled;
    public int worldType;
    public ArrayList<GearGroup> gearGroups;
    public int multiplayerDifficulty;
    public Minecraft mc;

    static {
        float f2 = 0.05f;
        int i2 = 0;
        while (i2 <= 15) {
            float f1 = 1.0f - (float)i2 / 15.0f;
            World.field_1042_i[i2] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f2) + f2;
            ++i2;
        }
    }

    public static NBTTagCompound func_629_a(File file, String s2) {
        File file1 = new File(file, "NSSSsaves");
        File file2 = new File(file1, s2);
        if (!file2.exists()) {
            return null;
        }
        File file3 = new File(file2, "level.dat");
        if (file3.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file3);
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(fis);
                NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("Data");
                fis.close();
                return nbttagcompound1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static void func_615_b(File file, String s2) {
        File file1 = new File(file, "NSSSsaves");
        File file2 = new File(file1, s2);
        if (!file2.exists()) {
            return;
        }
        World.func_653_a(file2.listFiles());
        file2.delete();
    }

    public static void func_615_b2(File file, String s2) {
        File file1 = new File(file, "NSSSservers");
        File file2 = new File(file1, s2);
        if (!file2.exists()) {
            return;
        }
        World.func_653_a(file2.listFiles());
        file2.delete();
    }

    private static void func_653_a(File[] afile) {
        RegionFileCache.clear();
        int i2 = 0;
        while (i2 < afile.length) {
            if (afile[i2].isDirectory()) {
                World.func_653_a(afile[i2].listFiles());
            }
            afile[i2].delete();
            ++i2;
        }
    }

    public World(File file, String s2, boolean snow, boolean cheatsDisabled, int worldType, Minecraft mine) {
        this(file, s2, new Random().nextLong(), snow, cheatsDisabled, worldType, mine);
    }

    public World(String s2, Minecraft mine) {
        this.field_1025_z = new ArrayList<MetadataChunkBlock>();
        this.loadedEntityList = new ArrayList<Entity>();
        this.unloadedEntityList = new ArrayList<Object>();
        this.field_1023_B = new TreeSet();
        this.field_1022_C = new HashSet<NextTickListEntry>();
        this.field_1049_b = new ArrayList<Object>();
        this.worldTime = 0L;
        this.snowCovered = false;
        this.field_1021_D = 0x88BBFFL;
        this.field_1020_E = 12638463L;
        this.field_1019_F = 0xFFFFFFL;
        this.skyLightSubtracted = 0;
        this.field_1045_f = new Random().nextInt();
        this.field_1044_g = 1013904223;
        this.etitingBlocks = false;
        this.field_1018_G = System.currentTimeMillis();
        this.saveRate = 40;
        this.playerEntities = new ArrayList<EntityPlayer>();
        this.weatherEffects = new ArrayList<Entity>();
        this.rand = new Random();
        this.isNewWorld = false;
        this.worldAccesses = new ArrayList<IWorldAccess>();
        this.randomSeed = 0L;
        this.sizeOnDisk = 0L;
        this.field_1015_J = new ArrayList();
        this.setOfTickableChunks = new HashSet<ChunkCoordIntPair>();
        this.ambienceChance = this.rand.nextInt(12000);
        this.field_1012_M = new ArrayList<Entity>();
        this.multiplayerWorld = false;
        this.field_1028_w = s2;
        this.chunkProvider = this.getWorldChunkProvider(this.worldFolder);
        this.gearGroups = new ArrayList();
        this.mc = mine;
        this.func_644_f();
    }

    public World(File file, String s2, long l2, boolean snowCovereds, boolean cheatsDisableds, int worldTypes, Minecraft mine) {
        this.cheatsDisabled = cheatsDisableds;
        this.field_1025_z = new ArrayList<MetadataChunkBlock>();
        this.loadedEntityList = new ArrayList<Entity>();
        this.unloadedEntityList = new ArrayList<Object>();
        this.field_1023_B = new TreeSet();
        this.field_1022_C = new HashSet<NextTickListEntry>();
        this.field_1049_b = new ArrayList<Object>();
        this.worldTime = 0L;
        this.snowCovered = snowCovereds;
        this.worldType = worldTypes;
        this.field_1021_D = 0x88BBFFL;
        this.field_1020_E = 12638463L;
        this.field_1019_F = 0xFFFFFFL;
        this.skyLightSubtracted = 0;
        this.field_1045_f = new Random().nextInt();
        this.field_1044_g = 1013904223;
        this.etitingBlocks = false;
        this.field_1018_G = System.currentTimeMillis();
        this.saveRate = 40;
        this.playerEntities = new ArrayList<EntityPlayer>();
        this.weatherEffects = new ArrayList<Entity>();
        this.rand = new Random();
        this.isNewWorld = false;
        this.worldAccesses = new ArrayList<IWorldAccess>();
        this.randomSeed = 0L;
        this.sizeOnDisk = 0L;
        this.field_1015_J = new ArrayList();
        this.setOfTickableChunks = new HashSet<ChunkCoordIntPair>();
        this.ambienceChance = this.rand.nextInt(12000);
        this.field_1012_M = new ArrayList<Entity>();
        this.multiplayerWorld = false;
        this.field_1028_w = s2;
        file.mkdirs();
        this.worldFolder = new File(file, s2);
        this.worldFolder.mkdirs();
        this.gearGroups = new ArrayList();
        this.mc = mine;
        try {
            File file1 = new File(this.worldFolder, "session.lock");
            DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file1));
            try {
                dataoutputstream.writeLong(this.field_1018_G);
            }
            finally {
                dataoutputstream.close();
            }
        }
        catch (IOException ioexception) {
            throw new RuntimeException("Failed to check session lock, aborting");
        }
        File file2 = new File(this.worldFolder, "level.dat");
        boolean bl2 = this.isNewWorld = !file2.exists();
        if (file2.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file2);
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(fis);
                NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("Data");
                this.randomSeed = nbttagcompound1.getLong("RandomSeed");
                this.spawnX = nbttagcompound1.getInteger("SpawnX");
                this.spawnY = nbttagcompound1.getInteger("SpawnY");
                this.spawnZ = nbttagcompound1.getInteger("SpawnZ");
                this.worldTime = nbttagcompound1.getLong("Time");
                this.sizeOnDisk = nbttagcompound1.getLong("SizeOnDisk");
                this.snowCovered = nbttagcompound1.getBoolean("SnowCovered");
                this.cheatsDisabled = nbttagcompound1.getBoolean("cheatsDisabled");
                this.worldType = nbttagcompound1.getBoolean("isFloating") ? 1 : nbttagcompound1.getInteger("WorldType");
                if (nbttagcompound1.hasKey("Player")) {
                    this.nbtCompoundPlayer = nbttagcompound1.getCompoundTag("Player");
                }
                fis.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean flag = false;
        if (this.randomSeed == 0L) {
            this.randomSeed = l2;
            flag = true;
        }
        this.chunkProvider = this.getWorldChunkProvider(this.worldFolder);
        if (flag) {
            this.field_1027_x = true;
            this.spawnX = 0;
            this.spawnY = 64;
            this.spawnZ = 0;
            while (!this.isThisBlockSpawnable(this.spawnX, this.spawnZ)) {
                this.spawnX += this.rand.nextInt(64) - this.rand.nextInt(64);
                this.spawnZ += this.rand.nextInt(64) - this.rand.nextInt(64);
            }
            this.field_1027_x = false;
        }
        this.func_644_f();
    }

    protected IChunkProvider getWorldChunkProvider(File file) {
        if (this.worldType == 1) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderSky(this, this.randomSeed));
        }
        if (this.worldType == 2) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderCorruption(this, this.randomSeed));
        }
        if (this.worldType == 3) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderDesert(this, this.randomSeed));
        }
        if (this.worldType == 4) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderIndev(this, this.randomSeed));
        }
        return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderGenerate(this, this.randomSeed));
    }

    public void func_622_a() {
        if (this.spawnY <= 0) {
            this.spawnY = 64;
        }
        while (this.getLowestSpawnableBlock(this.spawnX, this.spawnZ) == 0) {
            this.spawnX += this.rand.nextInt(8) - this.rand.nextInt(8);
            this.spawnZ += this.rand.nextInt(8) - this.rand.nextInt(8);
        }
    }

    public void setSpawnLocation() {
        if (this.spawnY <= 0) {
            this.spawnY = 64;
        }
        int i2 = this.spawnX;
        int j2 = this.spawnZ;
        while (this.getFirstUncoveredBlock(i2, j2) == 0) {
            i2 += this.rand.nextInt(8) - this.rand.nextInt(8);
            j2 += this.rand.nextInt(8) - this.rand.nextInt(8);
        }
        this.spawnX = i2;
        this.spawnZ = j2;
    }

    public int getFirstUncoveredBlock(int i2, int j2) {
        int k2 = 63;
        while (!this.isAirBlock(i2, k2 + 1, j2)) {
            ++k2;
        }
        return this.getBlockId(i2, k2, j2);
    }

    private boolean isThisBlockSpawnable(int x2, int z2) {
        int k2 = this.getLowestSpawnableBlock(x2, z2);
        if (this.worldType == 1 || this.worldType == 2 || this.worldType == 3) {
            return k2 == Block.grass.blockID;
        }
        return k2 == Block.sand.blockID;
    }

    private int getLowestSpawnableBlock(int x2, int z2) {
        int k2 = 63;
        while (this.getBlockId(x2, k2 + 1, z2) != 0) {
            ++k2;
        }
        return this.getBlockId(x2, k2, z2);
    }

    public void spawnPlayerWithLoadedChunks(EntityPlayer entityplayer) {
        try {
            if (this.nbtCompoundPlayer != null) {
                entityplayer.readFromNBT(this.nbtCompoundPlayer);
                this.nbtCompoundPlayer = null;
            }
            this.entityJoinedWorld(entityplayer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveAllChunks(boolean flag, IProgressUpdate iprogressupdate) {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        if (iprogressupdate != null) {
            iprogressupdate.func_594_b("Saving level");
        }
        this.loadWorldSaveInfo();
        if (iprogressupdate != null) {
            iprogressupdate.func_595_d("Saving chunks");
        }
        this.chunkProvider.saveChunks(flag, iprogressupdate);
        if (iprogressupdate != null) {
            RegionFileCache.clear();
        }
    }

    public void setSpawn(int x2, int y2, int z2) {
        this.spawnX = x2;
        this.spawnY = y2;
        this.spawnZ = z2;
    }

    private void loadWorldSaveInfo() {
        this.checkSessionLock();
        File getName = new File(this.worldFolder, "name.data");
        String lvlName = "New World";
        if (getName.exists()) {
            try {
                BufferedReader br2 = new BufferedReader(new FileReader(getName));
                lvlName = br2.readLine().replace("\u0000", "");
                br2.close();
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setLong("RandomSeed", this.randomSeed);
        nbttagcompound.setString("LevelName", lvlName);
        nbttagcompound.setInteger("SpawnX", this.spawnX);
        nbttagcompound.setInteger("SpawnY", this.spawnY);
        nbttagcompound.setInteger("SpawnZ", this.spawnZ);
        nbttagcompound.setLong("Time", this.worldTime);
        nbttagcompound.setLong("SizeOnDisk", this.sizeOnDisk);
        nbttagcompound.setBool("SnowCovered", this.snowCovered);
        nbttagcompound.setBool("cheatsDisabled", this.cheatsDisabled);
        nbttagcompound.setInteger("WorldType", this.worldType);
        nbttagcompound.setLong("LastPlayed", System.currentTimeMillis());
        EntityPlayer entityplayer = null;
        if (this.playerEntities.size() > 0) {
            entityplayer = this.playerEntities.get(0);
        }
        if (entityplayer != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            entityplayer.writeToNBT(nbttagcompound1);
            nbttagcompound.func_763_a("Player", nbttagcompound1);
        }
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.func_762_a("Data", nbttagcompound);
        try {
            File file = new File(this.worldFolder, "level.dat_new");
            File file1 = new File(this.worldFolder, "level.dat_old");
            File file2 = new File(this.worldFolder, "level.dat");
            FileOutputStream fos = new FileOutputStream(file);
            CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound2, fos);
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
            fos.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean func_650_a(int i2) {
        if (!this.chunkProvider.canSave()) {
            return true;
        }
        if (i2 == 0) {
            this.loadWorldSaveInfo();
        }
        return this.chunkProvider.saveChunks(false, null);
    }

    @Override
    public int getBlockId(int i2, int j2, int k2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return 0;
        }
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= 128) {
            return 0;
        }
        return this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4).getBlockId(i2 & 0xF, j2, k2 & 0xF);
    }

    public ArrayList<Vec3D> getBlockConnectedGears(int i2, int j2, int k2) {
        ArrayList<Vec3D> gears = new ArrayList<Vec3D>();
        if (this.getBlockId(i2 - 1, j2, k2) == Block.gear.blockID) {
            gears.add(Vec3D.createVectorHelper(i2 - 1, j2, k2));
            this.notifyBlockChange(i2 - 1, j2, k2, 0);
        }
        if (this.getBlockId(i2 + 1, j2, k2) == Block.gear.blockID) {
            gears.add(Vec3D.createVectorHelper(i2 + 1, j2, k2));
            this.notifyBlockChange(i2 - 1, j2, k2, 0);
        }
        if (this.getBlockId(i2, j2, k2 - 1) == Block.gear.blockID) {
            gears.add(Vec3D.createVectorHelper(i2, j2, k2 - 1));
            this.notifyBlockChange(i2 - 1, j2, k2, 0);
        }
        if (this.getBlockId(i2, j2, k2 + 1) == Block.gear.blockID) {
            gears.add(Vec3D.createVectorHelper(i2, j2, k2 + 1));
            this.notifyBlockChange(i2 - 1, j2, k2, 0);
        }
        return gears;
    }

    public boolean isSolidBlockTowardDirection(int posX, int posY, int posZ, int dirX, int dirZ) {
        return this.isBlockNormalCube(posX + dirX, posY, posZ + dirZ);
    }

    public int getGearPower(int x2, int y2, int z2) {
        TileEntity gearEntity = this.getBlockTileEntity(x2, y2, z2);
        if (gearEntity != null && gearEntity instanceof TileEntityGear) {
            return ((TileEntityGear)gearEntity).getGearPower();
        }
        return 0;
    }

    public int getGearTextureIndex(int x2, int y2, int z2) {
        int power = this.getGearPower(x2, y2, z2);
        if (power > 0) {
            return 78;
        }
        return 62;
    }

    public ArrayList<Vec3D> getGearConnectedGears(int i2, int j2, int k2) {
        ArrayList<Vec3D> gears = new ArrayList<Vec3D>();
        return gears;
    }

    public void addToGearList(TileEntityGear origin, TileEntityGear toAdd) {
        this.gearListCleanup();
        if (toAdd != null && !toAdd.isInGroup) {
            if (this.gearGroups.size() <= 1) {
                this.gearGroups.add(new GearGroup(this));
            }
            int i2 = 0;
            while (i2 < this.gearGroups.size() - 1) {
                if (this.gearGroups.get(i2).hasGear(origin) && !this.gearGroups.get(i2).hasGear(toAdd)) {
                    this.gearGroups.get(i2).addToGearGroup(toAdd);
                } else if (!this.gearGroups.get(i2).hasGear(origin)) {
                    this.gearGroups.add(new GearGroup(this));
                    this.gearGroups.get(this.gearGroups.size() - 1).addToGearGroup(origin);
                    this.gearGroups.get(this.gearGroups.size() - 1).addToGearGroup(toAdd);
                }
                ++i2;
            }
            toAdd.isInGroup = true;
        }
    }

    public GearGroup getGearGroupFromGear(TileEntityGear reference) {
        this.gearListCleanup();
        if (reference != null) {
            if (this.gearGroups.size() <= 1) {
                this.gearGroups.add(new GearGroup(this));
                this.gearGroups.get(0).addToGearGroup(reference);
                return this.gearGroups.get(0);
            }
            int i2 = 0;
            while (i2 < this.gearGroups.size()) {
                if (this.gearGroups.get(i2).hasGear(reference)) {
                    return this.gearGroups.get(i2);
                }
                ++i2;
            }
            this.gearGroups.add(new GearGroup(this));
            this.gearGroups.get(this.gearGroups.size() - 1).addToGearGroup(reference);
            return this.gearGroups.get(this.gearGroups.size() - 1);
        }
        return null;
    }

    public void addToGearList(TileEntityGear toAdd) {
        if (toAdd != null) {
            if (this.gearGroups.size() <= 1) {
                this.gearGroups.add(new GearGroup(this));
            }
            ArrayList<GearGroup> groups = new ArrayList<GearGroup>();
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x + 1, toAdd.y, toAdd.z)));
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x - 1, toAdd.y, toAdd.z)));
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x, toAdd.y + 1, toAdd.z)));
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x, toAdd.y - 1, toAdd.z)));
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x, toAdd.y, toAdd.z + 1)));
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x, toAdd.y, toAdd.z - 1)));
            ArrayList<GearGroup> filteredGroup = new ArrayList<GearGroup>();
            int i2 = 0;
            while (i2 < groups.size()) {
                if (groups.get(i2) != null) {
                    filteredGroup.add((GearGroup)groups.get(i2));
                }
                ++i2;
            }
            if (filteredGroup.size() != 0) {
                i2 = 0;
                while (i2 < filteredGroup.size()) {
                    if (filteredGroup.size() > 3) {
                        ((GearGroup)filteredGroup.get(0)).mergeGroup((GearGroup)filteredGroup.get(1));
                        filteredGroup.remove(1);
                    }
                    ++i2;
                }
                System.out.println(filteredGroup.size());
                ((GearGroup)filteredGroup.get(0)).addToGearGroup(toAdd);
            } else {
                GearGroup groupNew = new GearGroup(this);
                groupNew.addToGearGroup(toAdd);
                this.gearGroups.add(groupNew);
            }
            toAdd.isInGroup = true;
        }
    }

    public void removeFromGearList(TileEntityGear toRemove) {
        if (toRemove != null) {
            int i2 = 0;
            while (i2 < this.gearGroups.size()) {
                if (this.gearGroups.get(i2).hasGear(toRemove)) {
                    this.gearGroups.get(i2).removeFromGearGroup(toRemove);
                }
                ++i2;
            }
            toRemove.isInGroup = false;
        }
        this.gearListCleanup();
    }

    public void gearListCleanup() {
        int i2 = 0;
        while (i2 < this.gearGroups.size()) {
            if (this.gearGroups.get(i2).getGearGroupSize() == 0) {
                this.gearGroups.remove(i2);
            }
            ++i2;
        }
    }

    public boolean applyGearPower(TileEntityGear powered, int amount) {
        this.gearListCleanup();
        System.out.println("APPLYING " + powered);
        if (powered != null) {
            int i2 = 0;
            while (i2 < this.gearGroups.size() - 1) {
                System.out.println(this.gearGroups.get(i2));
                if (this.gearGroups.get(i2).hasGear(powered)) {
                    this.gearGroups.get(i2).setLimit(amount);
                    return this.gearGroups.get(i2).powerGearCache();
                }
                this.addToGearList(null, powered);
                ++i2;
            }
        }
        return false;
    }

    public boolean removeGearPower(TileEntityGear powered, int amount) {
        this.gearListCleanup();
        System.out.println("REMOVING " + powered);
        if (powered != null) {
            int i2 = 0;
            while (i2 < this.gearGroups.size() - 1) {
                System.out.println(this.gearGroups.get(i2));
                if (this.gearGroups.get(i2).hasGear(powered)) {
                    this.gearGroups.get(i2).setLimit(0);
                    return this.gearGroups.get(i2).unPowerGearCache();
                }
                this.addToGearList(null, powered);
                ++i2;
            }
        }
        return false;
    }

    public boolean checkGearPower(TileEntityGear toCheck) {
        this.gearListCleanup();
        if (toCheck != null) {
            int i2 = 0;
            while (i2 < this.gearGroups.size() - 1) {
                if (this.gearGroups.get(i2).hasGear(toCheck)) {
                    return this.gearGroups.get(i2).checkPowered();
                }
                ++i2;
            }
        }
        return false;
    }

    public TileEntityGear getGearAt(int x2, int y2, int z2) {
        TileEntity entity = this.getBlockTileEntity(x2, y2, z2);
        TileEntityGear gearEntity = null;
        if (entity instanceof TileEntityGear) {
            gearEntity = (TileEntityGear)entity;
        }
        return gearEntity;
    }

    public boolean blockExists(int i2, int j2, int k2) {
        if (j2 < 0 || j2 >= 128) {
            return false;
        }
        return this.chunkExists(i2 >> 4, k2 >> 4);
    }

    public boolean doChunksNearChunkExist(int i2, int j2, int k2, int l2) {
        return this.checkChunksExist(i2 - l2, j2 - l2, k2 - l2, i2 + l2, j2 + l2, k2 + l2);
    }

    public boolean checkChunksExist(int i2, int j2, int k2, int l2, int i1, int j1) {
        if (i1 < 0 || j2 >= 128) {
            return false;
        }
        i2 >>= 4;
        j2 >>= 4;
        k2 >>= 4;
        l2 >>= 4;
        i1 >>= 4;
        j1 >>= 4;
        int k1 = i2;
        while (k1 <= l2) {
            int l1 = k2;
            while (l1 <= j1) {
                if (!this.chunkExists(k1, l1)) {
                    return false;
                }
                ++l1;
            }
            ++k1;
        }
        return true;
    }

    private boolean chunkExists(int i2, int j2) {
        return this.chunkProvider.chunkExists(i2, j2);
    }

    public Chunk getChunkFromBlockCoords(int i2, int j2) {
        return this.getChunkFromChunkCoords(i2 >> 4, j2 >> 4);
    }

    public Chunk getChunkFromChunkCoords(int i2, int j2) {
        return this.chunkProvider.provideChunk(i2, j2);
    }

    public boolean setBlockAndMetadata(int i2, int j2, int k2, int l2, int i1) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return false;
        }
        if (j2 < 0) {
            return false;
        }
        if (j2 >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        return chunk.setBlockIDWithMetadata(i2 & 0xF, j2, k2 & 0xF, l2, i1);
    }

    public boolean setBlock(int i2, int j2, int k2, int l2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return false;
        }
        if (j2 < 0) {
            return false;
        }
        if (j2 >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        return chunk.setBlockID(i2 & 0xF, j2, k2 & 0xF, l2);
    }

    @Override
    public Material getMaterialXYZ(int i2, int j2, int k2) {
        int l2 = this.getBlockId(i2, j2, k2);
        if (l2 == 0) {
            return Material.air;
        }
        return Block.allBlocks[l2].blockMaterial;
    }

    @Override
    public boolean isTouchingAir(int x2, int y2, int z2) {
        return this.getBlockId(x2 - 1, y2, z2) == 0 || this.getBlockId(x2 + 1, y2, z2) == 0 || this.getBlockId(x2, y2 - 1, z2) == 0 || this.getBlockId(x2, y2 + 1, z2) == 0 || this.getBlockId(x2, y2, z2 - 1) == 0 || this.getBlockId(x2, y2, z2 + 1) == 0;
    }

    public boolean isAirBlock(int i2, int j2, int k2) {
        int l2 = this.getBlockId(i2, j2, k2);
        return l2 == 0;
    }

    @Override
    public int getBlockMetadata(int i2, int j2, int k2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return 0;
        }
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= 128) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        return chunk.getBlockMetadata(i2 &= 0xF, j2, k2 &= 0xF);
    }

    public void setBlockMetadataWithNotify(int i2, int j2, int k2, int l2) {
        this.setBlockMetadata(i2, j2, k2, l2);
        this.notifyBlockChange(i2, j2, k2, l2);
    }

    public boolean setBlockMetadata(int i2, int j2, int k2, int l2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return false;
        }
        if (j2 < 0) {
            return false;
        }
        if (j2 >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        chunk.setBlockMetadata(i2 &= 0xF, j2, k2 &= 0xF, l2);
        return true;
    }

    public boolean setBlockWithNotify(int i2, int j2, int k2, int l2) {
        if (this.setBlock(i2, j2, k2, l2)) {
            this.notifyBlockChange(i2, j2, k2, l2);
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadataWithNotify(int i2, int j2, int k2, int l2, int i1) {
        if (this.setBlockAndMetadata(i2, j2, k2, l2, i1)) {
            this.notifyBlockChange(i2, j2, k2, l2);
            return true;
        }
        return false;
    }

    public void markBlockNeedsUpdate(int i2, int j2, int k2) {
        int l2 = 0;
        while (l2 < this.worldAccesses.size()) {
            this.worldAccesses.get(l2).func_934_a(i2, j2, k2);
            ++l2;
        }
    }

    protected void notifyBlockChange(int i2, int j2, int k2, int l2) {
        this.markBlockNeedsUpdate(i2, j2, k2);
        this.notifyBlocksOfNeighborChange(i2, j2, k2, l2);
    }

    public void markBlocksDirtyVertical(int i2, int j2, int k2, int l2) {
        if (k2 > l2) {
            int i1 = l2;
            l2 = k2;
            k2 = i1;
        }
        this.markBlocksDirty(i2, k2, j2, i2, l2, j2);
    }

    public void markBlocksDirty(int i2, int j2, int k2, int l2, int i1, int j1) {
        int k1 = 0;
        while (k1 < this.worldAccesses.size()) {
            this.worldAccesses.get(k1).markBlockRangeNeedsUpdate(i2, j2, k2, l2, i1, j1);
            ++k1;
        }
    }

    public void notifyBlocksOfNeighborChange(int i2, int j2, int k2, int l2) {
        this.notifyBlockOfNeighborChange(i2 - 1, j2, k2, l2);
        this.notifyBlockOfNeighborChange(i2 + 1, j2, k2, l2);
        this.notifyBlockOfNeighborChange(i2, j2 - 1, k2, l2);
        this.notifyBlockOfNeighborChange(i2, j2 + 1, k2, l2);
        this.notifyBlockOfNeighborChange(i2, j2, k2 - 1, l2);
        this.notifyBlockOfNeighborChange(i2, j2, k2 + 1, l2);
    }

    private void notifyBlockOfNeighborChange(int i2, int j2, int k2, int l2) {
        if (this.etitingBlocks || this.multiplayerWorld) {
            return;
        }
        Block block = Block.allBlocks[this.getBlockId(i2, j2, k2)];
        if (block != null) {
            block.onNeighborBlockChange(this, i2, j2, k2, l2);
        }
    }

    public boolean func_647_i(int i2, int j2, int k2) {
        return this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4).canBlockSeeTheSky(i2 & 0xF, j2, k2 & 0xF);
    }

    public int getBlockLightValue(int i2, int j2, int k2) {
        return this.func_699_a(i2, j2, k2, true);
    }

    public int func_699_a(int i2, int j2, int k2, boolean flag) {
        int l2;
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return 15;
        }
        if (flag && ((l2 = this.getBlockId(i2, j2, k2)) == Block.stairSingle.blockID || l2 == Block.tilledField.blockID)) {
            int j1 = this.func_699_a(i2, j2 + 1, k2, false);
            int k1 = this.func_699_a(i2 + 1, j2, k2, false);
            int l1 = this.func_699_a(i2 - 1, j2, k2, false);
            int i22 = this.func_699_a(i2, j2, k2 + 1, false);
            int j22 = this.func_699_a(i2, j2, k2 - 1, false);
            if (k1 > j1) {
                j1 = k1;
            }
            if (l1 > j1) {
                j1 = l1;
            }
            if (i22 > j1) {
                j1 = i22;
            }
            if (j22 > j1) {
                j1 = j22;
            }
            return j1;
        }
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= 128) {
            int i1 = 15 - this.skyLightSubtracted;
            if (i1 < 0) {
                i1 = 0;
            }
            return i1;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        return chunk.getBlockLightValue(i2 &= 0xF, j2, k2 &= 0xF, this.skyLightSubtracted);
    }

    public boolean func_708_k(int i2, int j2, int k2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return false;
        }
        if (j2 < 0) {
            return false;
        }
        if (j2 >= 128) {
            return true;
        }
        if (!this.chunkExists(i2 >> 4, k2 >> 4)) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        return chunk.canBlockSeeTheSky(i2 &= 0xF, j2, k2 &= 0xF);
    }

    public int getHeightValue(int i2, int j2) {
        if (i2 < -32000000 || j2 < -32000000 || i2 >= 32000000 || j2 > 32000000) {
            return 0;
        }
        if (!this.chunkExists(i2 >> 4, j2 >> 4)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, j2 >> 4);
        return chunk.getHeightValue(i2 & 0xF, j2 & 0xF);
    }

    public void func_631_a(EnumSkyBlock enumskyblock, int i2, int j2, int k2, int l2) {
        int i1;
        if (!this.blockExists(i2, j2, k2)) {
            return;
        }
        if (enumskyblock == EnumSkyBlock.Sky) {
            if (this.func_708_k(i2, j2, k2)) {
                l2 = 15;
            }
        } else if (enumskyblock == EnumSkyBlock.Block && Block.lightValue[i1 = this.getBlockId(i2, j2, k2)] > l2) {
            l2 = Block.lightValue[i1];
        }
        if (this.getBlockLighting(enumskyblock, i2, j2, k2) != l2) {
            this.scheduleLightingUpdate(enumskyblock, i2, j2, k2, i2, j2, k2);
        }
    }

    public int getBlockLighting(EnumSkyBlock enumskyblock, int i2, int j2, int k2) {
        if (j2 < 0 || j2 >= 128 || i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return enumskyblock.field_1722_c;
        }
        int l2 = i2 >> 4;
        int i1 = k2 >> 4;
        if (!this.chunkExists(l2, i1)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(l2, i1);
        return chunk.getSavedLightValue(enumskyblock, i2 & 0xF, j2, k2 & 0xF);
    }

    public void func_664_b(EnumSkyBlock enumskyblock, int i2, int j2, int k2, int l2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return;
        }
        if (j2 < 0) {
            return;
        }
        if (j2 >= 128) {
            return;
        }
        if (!this.chunkExists(i2 >> 4, k2 >> 4)) {
            return;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        chunk.setLightValue(enumskyblock, i2 & 0xF, j2, k2 & 0xF, l2);
        int i1 = 0;
        while (i1 < this.worldAccesses.size()) {
            this.worldAccesses.get(i1).func_934_a(i2, j2, k2);
            ++i1;
        }
    }

    @Override
    public float getBrightness(int i2, int j2, int k2) {
        return field_1042_i[this.getBlockLightValue(i2, j2, k2)];
    }

    public boolean func_624_b() {
        return this.skyLightSubtracted < 4;
    }

    public MovingObjectPosition rayTraceBlocks(Vec3D vec3d, Vec3D vec3d1) {
        return this.rayTraceBlocks_do(vec3d, vec3d1, false);
    }

    public MovingObjectPosition rayTraceBlocks_do(Vec3D vec3d, Vec3D vec3d1, boolean flag) {
        if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
            return null;
        }
        if (Double.isNaN(vec3d1.xCoord) || Double.isNaN(vec3d1.yCoord) || Double.isNaN(vec3d1.zCoord)) {
            return null;
        }
        int i2 = MathHelper.floor_double(vec3d1.xCoord);
        int j2 = MathHelper.floor_double(vec3d1.yCoord);
        int k2 = MathHelper.floor_double(vec3d1.zCoord);
        int l2 = MathHelper.floor_double(vec3d.xCoord);
        int i1 = MathHelper.floor_double(vec3d.yCoord);
        int j1 = MathHelper.floor_double(vec3d.zCoord);
        int k1 = 20;
        while (k1-- >= 0) {
            MovingObjectPosition movingobjectposition;
            if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
                return null;
            }
            if (l2 == i2 && i1 == j2 && j1 == k2) {
                return null;
            }
            double d2 = 999.0;
            double d1 = 999.0;
            double d22 = 999.0;
            if (i2 > l2) {
                d2 = (double)l2 + 1.0;
            }
            if (i2 < l2) {
                d2 = (double)l2 + 0.0;
            }
            if (j2 > i1) {
                d1 = (double)i1 + 1.0;
            }
            if (j2 < i1) {
                d1 = (double)i1 + 0.0;
            }
            if (k2 > j1) {
                d22 = (double)j1 + 1.0;
            }
            if (k2 < j1) {
                d22 = (double)j1 + 0.0;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = vec3d1.xCoord - vec3d.xCoord;
            double d7 = vec3d1.yCoord - vec3d.yCoord;
            double d8 = vec3d1.zCoord - vec3d.zCoord;
            if (d2 != 999.0) {
                d3 = (d2 - vec3d.xCoord) / d6;
            }
            if (d1 != 999.0) {
                d4 = (d1 - vec3d.yCoord) / d7;
            }
            if (d22 != 999.0) {
                d5 = (d22 - vec3d.zCoord) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = i2 > l2 ? 4 : 5;
                vec3d.xCoord = d2;
                vec3d.yCoord += d7 * d3;
                vec3d.zCoord += d8 * d3;
            } else if (d4 < d5) {
                byte0 = j2 > i1 ? 0 : 1;
                vec3d.xCoord += d6 * d4;
                vec3d.yCoord = d1;
                vec3d.zCoord += d8 * d4;
            } else {
                byte0 = k2 > j1 ? 2 : 3;
                vec3d.xCoord += d6 * d5;
                vec3d.yCoord += d7 * d5;
                vec3d.zCoord = d22;
            }
            Vec3D vec3d2 = Vec3D.createVector(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
            vec3d2.xCoord = MathHelper.floor_double(vec3d.xCoord);
            l2 = (int)vec3d2.xCoord;
            if (byte0 == 5) {
                --l2;
                vec3d2.xCoord += 1.0;
            }
            vec3d2.yCoord = MathHelper.floor_double(vec3d.yCoord);
            i1 = (int)vec3d2.yCoord;
            if (byte0 == 1) {
                --i1;
                vec3d2.yCoord += 1.0;
            }
            vec3d2.zCoord = MathHelper.floor_double(vec3d.zCoord);
            j1 = (int)vec3d2.zCoord;
            if (byte0 == 3) {
                --j1;
                vec3d2.zCoord += 1.0;
            }
            int l1 = this.getBlockId(l2, i1, j1);
            int i22 = this.getBlockMetadata(l2, i1, j1);
            Block block = Block.allBlocks[l1];
            if (l1 <= 0 || !block.canCollideCheck(i22, flag) || (movingobjectposition = block.collisionRayTrace(this, l2, i1, j1, vec3d, vec3d1)) == null) continue;
            return movingobjectposition;
        }
        return null;
    }

    public void playSoundAtEntity(Entity entity, String s2, float f2, float f1) {
        int i2 = 0;
        while (i2 < this.worldAccesses.size()) {
            this.worldAccesses.get(i2).makeSound(s2, entity.posX, entity.posY - (double)entity.yOffset, entity.posZ, f2, f1);
            ++i2;
        }
    }

    public void playSoundEffect(double d2, double d1, double d22, String s2, float f2, float f1) {
        int i2 = 0;
        while (i2 < this.worldAccesses.size()) {
            this.worldAccesses.get(i2).makeSound(s2, d2, d1, d22, f2, f1);
            ++i2;
        }
    }

    public void playAmbience(double posX, double posY, double posZ, String soundName, float volume, float pitch) {
        int i2 = 0;
        while (i2 < this.worldAccesses.size()) {
            this.worldAccesses.get(i2).makeAmbience(soundName, posX, posY, posZ, volume, pitch);
            ++i2;
        }
    }

    public void updateAmbience(double posX, double posY, double posZ, String soundName, float volume, float pitch) {
        int i2 = 0;
        while (i2 < this.worldAccesses.size()) {
            this.worldAccesses.get(i2).updateAmbience(soundName, posX, posY, posZ, volume, pitch);
            ++i2;
        }
    }

    public boolean isAmbienceEnabled() {
        return this.worldAccesses.get(0).isAmbienceEnabled();
    }

    public IWorldAccess getWorldAccess(int i2) {
        return this.worldAccesses.get(i2);
    }

    public void playRecord(String s2, int i2, int j2, int k2) {
        int l2 = 0;
        while (l2 < this.worldAccesses.size()) {
            this.worldAccesses.get(l2).playRecord(s2, i2, j2, k2);
            ++l2;
        }
    }

    public void spawnParticle(String s2, double d2, double d1, double d22, double d3, double d4, double d5) {
        int i2 = 0;
        while (i2 < this.worldAccesses.size()) {
            try {
                this.worldAccesses.get(i2).spawnParticle(s2, d2, d1, d22, d3, d4, d5);
            }
            catch (Exception ex2) {
                System.out.println("Tried to render non-existant entity! Left server?");
            }
            ++i2;
        }
    }

    public boolean addWeatherEffect(Entity entity) {
        this.weatherEffects.add(entity);
        return true;
    }

    public boolean entityJoinedWorld(Entity entity) {
        int i2 = MathHelper.floor_double(entity.posX / 16.0);
        int j2 = MathHelper.floor_double(entity.posZ / 16.0);
        boolean flag = false;
        if (entity instanceof EntityPlayer) {
            flag = true;
            if (!this.multiplayerWorld) {
                this.getBlockId(this.spawnX, this.spawnY, this.spawnZ);
                int cfr_ignored_0 = Block.bleedingObsidian.blockID;
            }
        }
        if (flag || this.chunkExists(i2, j2)) {
            if (entity instanceof EntityPlayer && !this.playerEntities.contains(entity)) {
                this.playerEntities.add((EntityPlayer)entity);
                System.out.println("Player count: " + this.playerEntities.size());
            }
            this.getChunkFromChunkCoords(i2, j2).addEntity(entity);
            this.loadedEntityList.add(entity);
            this.obtainEntitySkin(entity);
            return true;
        }
        return false;
    }

    public void obtainEntitySkin(Entity entity) {
        int i2 = 0;
        while (i2 < this.worldAccesses.size()) {
            this.worldAccesses.get(i2).obtainEntitySkin(entity);
            ++i2;
        }
    }

    public void releaseEntitySkin(Entity entity) {
        int i2 = 0;
        while (i2 < this.worldAccesses.size()) {
            this.worldAccesses.get(i2).releaseEntitySkin(entity);
            ++i2;
        }
    }

    public void setEntityDead(Entity entity) {
        entity.setEntityDead();
        if (entity instanceof EntityPlayer) {
            this.playerEntities.remove((EntityPlayer)entity);
            System.out.println("Player count: " + this.playerEntities.size());
        }
    }

    public void func_613_a(IWorldAccess iworldaccess) {
        this.worldAccesses.add(iworldaccess);
    }

    public void func_672_b(IWorldAccess iworldaccess) {
        this.worldAccesses.remove(iworldaccess);
    }

    public List<AxisAlignedBB> getCollidingBoundingBoxes(Entity entity, AxisAlignedBB axisalignedbb) {
        this.field_1015_J.clear();
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        int k1 = i2;
        while (k1 < j2) {
            int l1 = i1;
            while (l1 < j1) {
                if (this.blockExists(k1, 64, l1)) {
                    int i22 = k2 - 1;
                    while (i22 < l2) {
                        Block block = Block.allBlocks[this.getBlockId(k1, i22, l1)];
                        if (!(block == null || (entity instanceof EntityItem || entity instanceof EntityGiant) && block.blockID == Block.leaves.blockID || entity instanceof EntityGiant && block.blockID == Block.wood.blockID)) {
                            block.getCollidingBoundingBoxes(this, k1, i22, l1, axisalignedbb, this.field_1015_J);
                        }
                        ++i22;
                    }
                }
                ++l1;
            }
            ++k1;
        }
        double d2 = 0.25;
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(entity, axisalignedbb.expand(d2, d2, d2));
        int j22 = 0;
        while (j22 < list.size()) {
            AxisAlignedBB axisalignedbb1 = list.get(j22).func_372_f_();
            if (axisalignedbb1 != null && axisalignedbb1.intersectsWith(axisalignedbb)) {
                this.field_1015_J.add(axisalignedbb1);
            }
            if ((axisalignedbb1 = entity.getCollisionBox(list.get(j22))) != null && axisalignedbb1.intersectsWith(axisalignedbb)) {
                this.field_1015_J.add(axisalignedbb1);
            }
            ++j22;
        }
        return this.field_1015_J;
    }

    public int getTimeOfDayBrightness(float f2) {
        float celestialAngle = this.getCelestialAngle(f2);
        float lightNess = 1.0f - (MathHelper.cos(celestialAngle * 3.141593f * 2.0f) * 2.0f + 0.5f);
        if (lightNess < 0.0f) {
            lightNess = 0.0f;
        }
        if (lightNess > 1.0f) {
            lightNess = 1.0f;
        }
        return (int)(lightNess * 11.0f);
    }

    public Vec3D func_626_b(float f2) {
        float f1 = this.getCelestialAngle(f2);
        float f22 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        float f3 = (float)(this.field_1021_D >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.field_1021_D >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.field_1021_D & 0xFFL) / 255.0f;
        return Vec3D.createVector(f3 *= f22, f4 *= f22, f5 *= f22);
    }

    public float getCelestialAngle(float f2) {
        int i2 = (int)(this.worldTime % 24000L);
        float f1 = ((float)i2 + f2) / 24000.0f - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f22 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f22 + (f1 - f22) / 3.0f;
        return f1;
    }

    public Vec3D func_628_d(float f2) {
        float f1 = this.getCelestialAngle(f2);
        float f22 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        float f3 = (float)(this.field_1019_F >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.field_1019_F >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.field_1019_F & 0xFFL) / 255.0f;
        return Vec3D.createVector(f3 *= f22 * 0.9f + 0.1f, f4 *= f22 * 0.9f + 0.1f, f5 *= f22 * 0.85f + 0.15f);
    }

    public Vec3D func_686_e(float f2) {
        float f1 = this.getCelestialAngle(f2);
        float f22 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        float f3 = (float)(this.field_1020_E >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.field_1020_E >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.field_1020_E & 0xFFL) / 255.0f;
        return Vec3D.createVector(f3 *= f22 * 0.94f + 0.06f, f4 *= f22 * 0.94f + 0.06f, f5 *= f22 * 0.91f + 0.09f);
    }

    public int getTopSolidOrLiquidBlock(int i2, int j2) {
        Chunk chunk = this.getChunkFromBlockCoords(i2, j2);
        i2 &= 0xF;
        j2 &= 0xF;
        for (int k2 = 127; k2 > 0; --k2) {
            int l2 = chunk.getBlockId(i2, k2, j2);
            if (l2 == 0 || !Block.allBlocks[l2].blockMaterial.blocksMovement() && !Block.allBlocks[l2].blockMaterial.getIsGroundCover()) {
                continue;
            }
            return k2 + 1;
        }
        return -1;
    }

    public int func_696_e(int i2, int j2) {
        return this.getChunkFromBlockCoords(i2, j2).getHeightValue(i2 & 0xF, j2 & 0xF);
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(this.spawnX, this.spawnY, this.spawnZ);
    }

    public void setSpawnPoint(ChunkCoordinates chunkcoordinates) {
        this.spawnX = chunkcoordinates.x;
        this.spawnY = chunkcoordinates.y;
        this.spawnZ = chunkcoordinates.z;
    }

    public float func_679_f(float f2) {
        float f1 = this.getCelestialAngle(f2);
        float f22 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.75f);
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        return f22 * f22 * 0.5f;
    }

    public void scheduleUpdateTick(int i2, int j2, int k2, int l2) {
        NextTickListEntry nextticklistentry = new NextTickListEntry(i2, j2, k2, l2);
        int byte0 = 8;
        if (this.checkChunksExist(i2 - byte0, j2 - byte0, k2 - byte0, i2 + byte0, j2 + byte0, k2 + byte0)) {
            if (l2 > 0) {
                nextticklistentry.func_900_a((long)Block.allBlocks[l2].tickRate() + this.worldTime);
            }
            if (!this.field_1022_C.contains(nextticklistentry)) {
                this.field_1022_C.add(nextticklistentry);
                this.field_1023_B.add(nextticklistentry);
            }
        }
    }

    public void updateEntityList() {
        Entity entity;
        int i2 = 0;
        while (i2 < this.weatherEffects.size()) {
            entity = this.weatherEffects.get(i2);
            entity.onUpdate();
            if (entity.isDead) {
                this.weatherEffects.remove(i2--);
            }
            ++i2;
        }
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        i2 = 0;
        while (i2 < this.unloadedEntityList.size()) {
            entity = (Entity)this.unloadedEntityList.get(i2);
            int i1 = entity.chunkCoordX;
            int k1 = entity.chunkCoordZ;
            if (entity.addedToChunk && this.chunkExists(i1, k1)) {
                this.getChunkFromChunkCoords(i1, k1).removeEntity(entity);
            }
            ++i2;
        }
        int j2 = 0;
        while (j2 < this.unloadedEntityList.size()) {
            this.releaseEntitySkin((Entity)this.unloadedEntityList.get(j2));
            ++j2;
        }
        this.unloadedEntityList.clear();
        int k2 = 0;
        while (k2 < this.loadedEntityList.size()) {
            block14: {
                Entity entity1;
                block13: {
                    entity1 = this.loadedEntityList.get(k2);
                    if (entity1.entityBeingRidden == null) break block13;
                    if (!entity1.entityBeingRidden.isDead && entity1.entityBeingRidden.riddenByEntity == entity1) break block14;
                    entity1.entityBeingRidden.riddenByEntity = null;
                    entity1.entityBeingRidden = null;
                }
                if (!entity1.isDead) {
                    this.updateEntityWithOptionalForce(entity1);
                }
                if (entity1.isDead) {
                    int j1 = entity1.chunkCoordX;
                    int l1 = entity1.chunkCoordZ;
                    if (entity1.addedToChunk && this.chunkExists(j1, l1)) {
                        this.getChunkFromChunkCoords(j1, l1).removeEntity(entity1);
                    }
                    this.loadedEntityList.remove(k2--);
                    this.releaseEntitySkin(entity1);
                }
            }
            ++k2;
        }
        int l2 = 0;
        while (l2 < this.field_1049_b.size()) {
            TileEntity tileentity = (TileEntity)this.field_1049_b.get(l2);
            tileentity.func_475_b();
            ++l2;
        }
    }

    protected void updateEntityWithOptionalForce(Entity entity) {
        int j2;
        int byte0;
        int i2 = MathHelper.floor_double(entity.posX);
        if (!this.checkChunksExist(i2 - (byte0 = 16), 0, (j2 = MathHelper.floor_double(entity.posZ)) - byte0, i2 + byte0, 128, j2 + byte0)) {
            return;
        }
        entity.lastTickPosX = entity.posX;
        entity.lastTickPosY = entity.posY;
        entity.lastTickPosZ = entity.posZ;
        entity.prevRotationYaw = entity.rotationYaw;
        entity.prevRotationPitch = entity.rotationPitch;
        if (entity.entityBeingRidden != null) {
            entity.updateRidden();
        } else {
            entity.onUpdate();
        }
        int k2 = MathHelper.floor_double(entity.posX / 16.0);
        int l2 = MathHelper.floor_double(entity.posY / 16.0);
        int i1 = MathHelper.floor_double(entity.posZ / 16.0);
        if (!entity.addedToChunk || entity.chunkCoordX != k2 || entity.chunkCoordY != l2 || entity.chunkCoordZ != i1) {
            if (entity.addedToChunk && this.chunkExists(entity.chunkCoordX, entity.chunkCoordZ)) {
                this.getChunkFromChunkCoords(entity.chunkCoordX, entity.chunkCoordZ).removeEntityAtIndex(entity, entity.chunkCoordY);
            }
            if (this.chunkExists(k2, i1)) {
                this.getChunkFromChunkCoords(k2, i1).addEntity(entity);
            } else {
                entity.addedToChunk = false;
                System.out.println("Removing entity because it's not in a chunk!!");
                entity.setEntityDead();
            }
        }
        if (entity.riddenByEntity != null) {
            if (entity.riddenByEntity.isDead || entity.riddenByEntity.entityBeingRidden != entity) {
                entity.riddenByEntity.entityBeingRidden = null;
                entity.riddenByEntity = null;
            } else {
                this.updateEntityWithOptionalForce(entity.riddenByEntity);
            }
        }
        if (Double.isNaN(entity.posX) || Double.isInfinite(entity.posX)) {
            entity.posX = entity.lastTickPosX;
        }
        if (Double.isNaN(entity.posY) || Double.isInfinite(entity.posY)) {
            entity.posY = entity.lastTickPosY;
        }
        if (Double.isNaN(entity.posZ) || Double.isInfinite(entity.posZ)) {
            entity.posZ = entity.lastTickPosZ;
        }
        if (Double.isNaN(entity.rotationPitch) || Double.isInfinite(entity.rotationPitch)) {
            entity.rotationPitch = entity.prevRotationPitch;
        }
        if (Double.isNaN(entity.rotationYaw) || Double.isInfinite(entity.rotationYaw)) {
            entity.rotationYaw = entity.prevRotationYaw;
        }
    }

    public boolean func_604_a(AxisAlignedBB axisalignedbb) {
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb);
        int i2 = 0;
        while (i2 < list.size()) {
            Entity entity = list.get(i2);
            if (!entity.isDead && entity.preventEntitySpawning) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean getIsAnyLiquid(AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        if (axisalignedbb.minX < 0.0) {
            --i2;
        }
        if (axisalignedbb.minY < 0.0) {
            --k2;
        }
        if (axisalignedbb.minZ < 0.0) {
            --i1;
        }
        int k1 = i2;
        while (k1 < j2) {
            int l1 = k2;
            while (l1 < l2) {
                int i22 = i1;
                while (i22 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i22)];
                    if (block != null && block.blockMaterial.getIsGroundCover()) {
                        return true;
                    }
                    ++i22;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean isBoundingBoxBurning(AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        int k1 = i2;
        while (k1 < j2) {
            int l1 = k2;
            while (l1 < l2) {
                int i22 = i1;
                while (i22 < j1) {
                    int j22 = this.getBlockId(k1, l1, i22);
                    if (j22 == Block.fire.blockID || j22 == Block.lavaMoving.blockID || j22 == Block.lavaStill.blockID) {
                        return true;
                    }
                    ++i22;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean handleMaterialAcceleration(AxisAlignedBB axisalignedbb, Material material, Entity entity) {
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        boolean flag = false;
        Vec3D vec3d = Vec3D.createVector(0.0, 0.0, 0.0);
        int k1 = i2;
        while (k1 < j2) {
            int l1 = k2;
            while (l1 < l2) {
                int i22 = i1;
                while (i22 < j1) {
                    double d1;
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i22)];
                    if (block != null && block.blockMaterial == material && (double)l2 >= (d1 = (double)((float)(l1 + 1) - BlockFluids.getFluidLevel(this.getBlockMetadata(k1, l1, i22))))) {
                        flag = true;
                        block.velocityToAddToEntity(this, k1, l1, i22, entity, vec3d);
                    }
                    ++i22;
                }
                ++l1;
            }
            ++k1;
        }
        if (vec3d.lengthVector() > 0.0) {
            vec3d = vec3d.normalize();
            double d2 = 0.004;
            entity.motionX += vec3d.xCoord * d2;
            entity.motionY += vec3d.yCoord * d2;
            entity.motionZ += vec3d.zCoord * d2;
        }
        return flag;
    }

    public boolean func_689_a(AxisAlignedBB axisalignedbb, Material material) {
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        int k1 = i2;
        while (k1 < j2) {
            int l1 = k2;
            while (l1 < l2) {
                int i22 = i1;
                while (i22 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i22)];
                    if (block != null && block.blockMaterial == material) {
                        return true;
                    }
                    ++i22;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean isAABBInMaterial(AxisAlignedBB axisalignedbb, Material material) {
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        int k1 = i2;
        while (k1 < j2) {
            int l1 = k2;
            while (l1 < l2) {
                int i22 = i1;
                while (i22 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i22)];
                    if (block != null && block.blockMaterial == material) {
                        int j22 = this.getBlockMetadata(k1, l1, i22);
                        double d2 = l1 + 1;
                        if (j22 < 8) {
                            d2 = (double)(l1 + 1) - (double)j22 / 8.0;
                        }
                        if (d2 >= axisalignedbb.minY) {
                            return true;
                        }
                    }
                    ++i22;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public void createExplosion(Entity entity, double d2, double d1, double d22, float f2) {
        new Explosion().func_901_a(this, entity, d2, d1, d22, f2);
    }

    public float func_675_a(Vec3D vec3d, AxisAlignedBB axisalignedbb) {
        double d2 = 1.0 / ((axisalignedbb.maxX - axisalignedbb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.maxY - axisalignedbb.minY) * 2.0 + 1.0);
        double d22 = 1.0 / ((axisalignedbb.maxZ - axisalignedbb.minZ) * 2.0 + 1.0);
        int i2 = 0;
        int j2 = 0;
        float f2 = 0.0f;
        while (f2 <= 1.0f) {
            float f1 = 0.0f;
            while (f1 <= 1.0f) {
                float f22 = 0.0f;
                while (f22 <= 1.0f) {
                    double d3 = axisalignedbb.minX + (axisalignedbb.maxX - axisalignedbb.minX) * (double)f2;
                    double d4 = axisalignedbb.minY + (axisalignedbb.maxY - axisalignedbb.minY) * (double)f1;
                    double d5 = axisalignedbb.minZ + (axisalignedbb.maxZ - axisalignedbb.minZ) * (double)f22;
                    if (this.rayTraceBlocks(Vec3D.createVector(d3, d4, d5), vec3d) == null) {
                        ++i2;
                    }
                    ++j2;
                    f22 = (float)((double)f22 + d22);
                }
                f1 = (float)((double)f1 + d1);
            }
            f2 = (float)((double)f2 + d2);
        }
        return (float)i2 / (float)j2;
    }

    public void func_612_i(int i2, int j2, int k2, int l2) {
        if (l2 == 0) {
            --j2;
        }
        if (l2 == 1) {
            ++j2;
        }
        if (l2 == 2) {
            --k2;
        }
        if (l2 == 3) {
            ++k2;
        }
        if (l2 == 4) {
            --i2;
        }
        if (l2 == 5) {
            ++i2;
        }
        if (this.getBlockId(i2, j2, k2) == Block.fire.blockID) {
            this.playSoundEffect((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, "random.fizz", 0.5f, 2.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.8f);
            this.setBlockWithNotify(i2, j2, k2, 0);
        }
    }

    public Entity func_661_a(Class<?> class1) {
        return null;
    }

    public String func_687_d() {
        return "All entities: " + this.loadedEntityList.size();
    }

    @Override
    public TileEntity getBlockTileEntity(int i2, int j2, int k2) {
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        if (chunk != null) {
            return chunk.getChunkBlockTileEntity(i2 & 0xF, j2, k2 & 0xF);
        }
        return null;
    }

    public void func_654_a(int i2, int j2, int k2, TileEntity tileentity) {
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        if (chunk != null) {
            chunk.setChunkBlockTileEntity(i2 & 0xF, j2, k2 & 0xF, tileentity);
        }
    }

    public void func_692_l(int i2, int j2, int k2) {
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        if (chunk != null) {
            chunk.removeChunkBlockTileEntity(i2 & 0xF, j2, k2 & 0xF);
        }
    }

    @Override
    public boolean isBlockNormalCube(int i2, int j2, int k2) {
        Block block = Block.allBlocks[this.getBlockId(i2, j2, k2)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    public boolean isWater(int i2, int j2, int k2) {
        Block block = Block.allBlocks[this.getBlockId(i2, j2, k2)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial == Material.water;
    }

    public void doWorldSave(IProgressUpdate iprogressupdate) {
        this.saveAllChunks(true, iprogressupdate);
    }

    public boolean func_638_e() {
        int i2 = 1000;
        while (this.field_1025_z.size() > 0) {
            if (--i2 <= 0) {
                return true;
            }
            this.field_1025_z.remove(this.field_1025_z.size() - 1).func_865_a(this);
        }
        return false;
    }

    public void scheduleLightingUpdate(EnumSkyBlock enumskyblock, int i2, int j2, int k2, int l2, int i1, int j1) {
        this.func_627_a(enumskyblock, i2, j2, k2, l2, i1, j1, true);
    }

    public void func_627_a(EnumSkyBlock enumskyblock, int i2, int j2, int k2, int l2, int i1, int j1, boolean flag) {
        int k1 = (l2 + i2) / 2;
        int l1 = (j1 + k2) / 2;
        if (!this.blockExists(k1, 64, l1)) {
            return;
        }
        int i22 = this.field_1025_z.size();
        if (flag) {
            int j22 = 4;
            if (j22 > i22) {
                j22 = i22;
            }
            int k22 = 0;
            while (k22 < j22) {
                MetadataChunkBlock metadatachunkblock = this.field_1025_z.get(this.field_1025_z.size() - k22 - 1);
                if (metadatachunkblock.field_1299_a == enumskyblock && metadatachunkblock.func_866_a(i2, j2, k2, l2, i1, j1)) {
                    return;
                }
                ++k22;
            }
        }
        this.field_1025_z.add(new MetadataChunkBlock(enumskyblock, i2, j2, k2, l2, i1, j1));
    }

    public void func_644_f() {
        int i2 = this.getTimeOfDayBrightness(1.0f);
        if (i2 != this.skyLightSubtracted) {
            this.skyLightSubtracted = i2;
        }
    }

    public void setSaveInterval(int interval) {
        this.saveRate = interval * 20 + 40;
    }

    public void tick() {
        this.chunkProvider.unload100OldestChunks();
        int timeOfDayBrightness = this.getTimeOfDayBrightness(1.0f);
        if (timeOfDayBrightness != this.skyLightSubtracted) {
            this.skyLightSubtracted = timeOfDayBrightness;
            int j2 = 0;
            while (j2 < this.worldAccesses.size()) {
                this.worldAccesses.get(j2).updateAllRenderers();
                ++j2;
            }
        }
        ++this.worldTime;
        if (this.worldTime % (long)this.saveRate == 0L) {
            this.saveAllChunks(false, null);
        }
        this.tickUpdates(false);
        this.doWorldTick();
    }

    protected void doWorldTick() {
        this.setOfTickableChunks.clear();
        int i2 = 0;
        while (i2 < this.playerEntities.size()) {
            EntityPlayer entityplayer = this.playerEntities.get(i2);
            int playerPosX = MathHelper.floor_double(entityplayer.posX / 16.0);
            int playerPosZ = MathHelper.floor_double(entityplayer.posZ / 16.0);
            int chunkRadius = 9;
            int cX = -chunkRadius;
            while (cX <= chunkRadius) {
                int cZ = -chunkRadius;
                while (cZ <= chunkRadius) {
                    this.setOfTickableChunks.add(new ChunkCoordIntPair(cX + playerPosX, cZ + playerPosZ));
                    ++cZ;
                }
                ++cX;
            }
            ++i2;
        }
        if (this.ambienceChance > 0) {
            --this.ambienceChance;
        }
        for (ChunkCoordIntPair chunkcoordintpair : this.setOfTickableChunks) {
            int i5;
            int j4;
            int k3;
            int l2;
            int l1;
            int chunkX = chunkcoordintpair.chunkX * 16;
            int chunkZ = chunkcoordintpair.chunkZ * 16;
            Chunk chunk = this.getChunkFromChunkCoords(chunkcoordintpair.chunkX, chunkcoordintpair.chunkZ);
            if (this.ambienceChance == 0) {
                EntityPlayer entityplayer1;
                this.field_1045_f = this.field_1045_f * 3 + this.field_1044_g;
                int k1 = this.field_1045_f >> 2;
                int k2 = k1 & 0xF;
                int j3 = k1 >> 8 & 0xF;
                int i4 = k1 >> 16 & 0x7F;
                int l4 = chunk.getBlockId(k2, i4, j3);
                if (l4 == 0 && this.getBlockLightValue(k2 += chunkX, i4, j3 += chunkZ) <= this.rand.nextInt(8) && this.getBlockLighting(EnumSkyBlock.Sky, k2, i4, j3) <= 0 && (entityplayer1 = this.getClosestPlayer((double)k2 + 0.5, (double)i4 + 0.5, (double)j3 + 0.5, 8.0)) != null && entityplayer1.getDistanceSq((double)k2 + 0.5, (double)i4 + 0.5, (double)j3 + 0.5) > 4.0) {
                    this.playSoundEffect((double)k2 + 0.5, (double)i4 + 0.5, (double)j3 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.rand.nextFloat() * 0.2f);
                    this.ambienceChance = this.rand.nextInt(12000) + 6000;
                }
            }
            if (this.snowCovered && this.rand.nextInt(4) == 0) {
                this.field_1045_f = this.field_1045_f * 3 + this.field_1044_g;
                l1 = this.field_1045_f >> 2;
                l2 = l1 & 0xF;
                k3 = l1 >> 8 & 0xF;
                j4 = this.getTopSolidOrLiquidBlock(l2 + chunkX, k3 + chunkZ);
                if (j4 >= 0 && j4 < 128 && chunk.getSavedLightValue(EnumSkyBlock.Block, l2, j4, k3) < 10) {
                    i5 = chunk.getBlockId(l2, j4 - 1, k3);
                    if (chunk.getBlockId(l2, j4, k3) == 0 && Block.snow.canPlace(this, l2 + chunkX, j4, k3 + chunkZ)) {
                        this.setBlockWithNotify(l2 + chunkX, j4, k3 + chunkZ, Block.snow.blockID);
                    }
                    if (i5 == Block.waterStill.blockID && chunk.getBlockMetadata(l2, j4 - 1, k3) == 0) {
                        this.setBlockWithNotify(l2 + chunkX, j4 - 1, k3 + chunkZ, Block.ice.blockID);
                    }
                }
            }
            if (!this.snowCovered && this.rand.nextInt(4) == 0) {
                this.field_1045_f = this.field_1045_f * 3 + this.field_1044_g;
                l1 = this.field_1045_f >> 2;
                l2 = l1 & 0xF;
                k3 = l1 >> 8 & 0xF;
                j4 = this.getTopSolidOrLiquidBlock(l2 + chunkX, k3 + chunkZ);
                if (j4 >= 0 && j4 < 128 && chunk.getSavedLightValue(EnumSkyBlock.Block, l2, j4, k3) < 10) {
                    i5 = chunk.getBlockId(l2, j4 - 1, k3);
                    if (chunk.getBlockId(l2, j4, k3) == Block.snow.blockID) {
                        this.setBlockWithNotify(l2 + chunkX, j4, k3 + chunkZ, 0);
                    }
                    if (i5 == Block.ice.blockID && chunk.getBlockMetadata(l2, j4 - 1, k3) == 0) {
                        this.setBlockWithNotify(l2 + chunkX, j4 - 1, k3 + chunkZ, Block.waterStill.blockID);
                    }
                }
            }
            int i22 = 0;
            while (i22 < 80) {
                this.field_1045_f = this.field_1045_f * 3 + this.field_1044_g;
                int i3 = this.field_1045_f >> 2;
                int l3 = i3 & 0xF;
                int k4 = i3 >> 8 & 0xF;
                int j5 = i3 >> 16 & 0x7F;
                byte byte1 = chunk.blocks[l3 << 11 | k4 << 7 | j5];
                if (Block.tickOnLoad[byte1]) {
                    Block.allBlocks[byte1].updateTick(this, l3 + chunkX, j5, k4 + chunkZ, this.rand);
                }
                ++i22;
            }
        }
    }

    public boolean tickUpdates(boolean flag) {
        int i2 = this.field_1023_B.size();
        if (i2 != this.field_1022_C.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (i2 > 1000) {
            i2 = 1000;
        }
        int j2 = 0;
        while (j2 < i2) {
            int k2;
            NextTickListEntry nextticklistentry = this.field_1023_B.first();
            if (!flag && nextticklistentry.field_1364_e > this.worldTime) break;
            this.field_1023_B.remove(nextticklistentry);
            this.field_1022_C.remove(nextticklistentry);
            int byte0 = 8;
            if (this.checkChunksExist(nextticklistentry.field_1361_a - byte0, nextticklistentry.field_1360_b - byte0, nextticklistentry.field_1366_c - byte0, nextticklistentry.field_1361_a + byte0, nextticklistentry.field_1360_b + byte0, nextticklistentry.field_1366_c + byte0) && (k2 = this.getBlockId(nextticklistentry.field_1361_a, nextticklistentry.field_1360_b, nextticklistentry.field_1366_c)) == nextticklistentry.field_1365_d && k2 > 0) {
                Block.allBlocks[k2].updateTick(this, nextticklistentry.field_1361_a, nextticklistentry.field_1360_b, nextticklistentry.field_1366_c, this.rand);
            }
            ++j2;
        }
        return this.field_1023_B.size() != 0;
    }

    public void func_677_m(int i2, int j2, int k2) {
        int byte0 = 16;
        Random random = new Random();
        int l2 = 0;
        while (l2 < 1000) {
            int k1;
            int j1;
            int i1 = i2 + this.rand.nextInt(byte0) - this.rand.nextInt(byte0);
            int l1 = this.getBlockId(i1, j1 = j2 + this.rand.nextInt(byte0) - this.rand.nextInt(byte0), k1 = k2 + this.rand.nextInt(byte0) - this.rand.nextInt(byte0));
            if (l1 > 0) {
                Block.allBlocks[l1].randomDisplayTick(this, i1, j1, k1, random);
            }
            ++l2;
        }
    }

    public List<Entity> getEntitiesWithinAABBExcludingEntity(Entity entity, AxisAlignedBB axisalignedbb) {
        this.field_1012_M.clear();
        int i2 = MathHelper.floor_double((axisalignedbb.minX - 2.0) / 16.0);
        int j2 = MathHelper.floor_double((axisalignedbb.maxX + 2.0) / 16.0);
        int k2 = MathHelper.floor_double((axisalignedbb.minZ - 2.0) / 16.0);
        int l2 = MathHelper.floor_double((axisalignedbb.maxZ + 2.0) / 16.0);
        int i1 = i2;
        while (i1 <= j2) {
            int j1 = k2;
            while (j1 <= l2) {
                if (this.chunkExists(i1, j1)) {
                    this.getChunkFromChunkCoords(i1, j1).getEntitiesWithinAABBForEntity(entity, axisalignedbb, this.field_1012_M);
                }
                ++j1;
            }
            ++i1;
        }
        return this.field_1012_M;
    }

    public List<Entity> getEntitiesWithinAABB(Class<?> class1, AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.floor_double((axisalignedbb.minX - 2.0) / 16.0);
        int j2 = MathHelper.floor_double((axisalignedbb.maxX + 2.0) / 16.0);
        int k2 = MathHelper.floor_double((axisalignedbb.minZ - 2.0) / 16.0);
        int l2 = MathHelper.floor_double((axisalignedbb.maxZ + 2.0) / 16.0);
        ArrayList<Entity> arraylist = new ArrayList<Entity>();
        int i1 = i2;
        while (i1 <= j2) {
            int j1 = k2;
            while (j1 <= l2) {
                if (this.chunkExists(i1, j1)) {
                    this.getChunkFromChunkCoords(i1, j1).getEntitiesOfTypeWithinAAAB(class1, axisalignedbb, arraylist);
                }
                ++j1;
            }
            ++i1;
        }
        return arraylist;
    }

    public List<Entity> getLoadedEntityList() {
        return this.loadedEntityList;
    }

    public void cacheTileEntity(int i2, int j2, int k2, TileEntity tileentity) {
        if (this.blockExists(i2, j2, k2)) {
            this.getChunkFromBlockCoords(i2, k2).setChunkModified();
        }
        int l2 = 0;
        while (l2 < this.worldAccesses.size()) {
            this.worldAccesses.get(l2).hashTileEntity(i2, j2, k2, tileentity);
            ++l2;
        }
    }

    public int func_621_b(Class<?> class1) {
        int i2 = 0;
        int j2 = 0;
        while (j2 < this.loadedEntityList.size()) {
            Entity entity = this.loadedEntityList.get(j2);
            if (class1.isAssignableFrom(entity.getClass())) {
                ++i2;
            }
            ++j2;
        }
        return i2;
    }

    public void addLoadedEntities(List<Entity> list) {
        this.loadedEntityList.addAll(list);
        int i2 = 0;
        while (i2 < list.size()) {
            this.obtainEntitySkin(list.get(i2));
            ++i2;
        }
    }

    public void addUnloadedEntities(List<Entity> field_1528_m) {
        this.unloadedEntityList.addAll(field_1528_m);
    }

    public void func_656_j() {
        while (this.chunkProvider.unload100OldestChunks()) {
        }
    }

    public IChunkProvider getIChunkProvider() {
        return this.chunkProvider;
    }

    public boolean func_695_a(int i2, int j2, int k2, int l2, boolean flag) {
        int i1 = this.getBlockId(j2, k2, l2);
        Block block = Block.allBlocks[i1];
        Block block1 = Block.allBlocks[i2];
        AxisAlignedBB axisalignedbb = block1.getCollisionBoundingBoxFromPool(this, j2, k2, l2);
        if (flag) {
            axisalignedbb = null;
        }
        if (axisalignedbb != null && !this.func_604_a(axisalignedbb)) {
            return false;
        }
        if (block == Block.waterMoving || block == Block.waterStill || block == Block.lavaMoving || block == Block.lavaStill || block == Block.fire || block == Block.snow) {
            return true;
        }
        return i2 > 0 && block == null && block1.canPlace(this, j2, k2, l2);
    }

    public PathEntity getPathEntityToEntity(Entity entity, Entity entity1, float f2) {
        int i2 = MathHelper.floor_double(entity.posX);
        int j2 = MathHelper.floor_double(entity.posY);
        int k2 = MathHelper.floor_double(entity.posZ);
        int l2 = (int)(f2 + 16.0f);
        int i1 = i2 - l2;
        int j1 = j2 - l2;
        int k1 = k2 - l2;
        int l1 = i2 + l2;
        int i22 = j2 + l2;
        int j22 = k2 + l2;
        ChunkCache chunkcache = new ChunkCache(this, i1, j1, k1, l1, i22, j22);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, entity1, f2);
    }

    public PathEntity func_637_a(Entity entity, int i2, int j2, int k2, float f2) {
        int l2 = MathHelper.floor_double(entity.posX);
        int i1 = MathHelper.floor_double(entity.posY);
        int j1 = MathHelper.floor_double(entity.posZ);
        int k1 = (int)(f2 + 8.0f);
        int l1 = l2 - k1;
        int i22 = i1 - k1;
        int j22 = j1 - k1;
        int k22 = l2 + k1;
        int l22 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(this, l1, i22, j22, k22, l22, i3);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, i2, j2, k2, f2);
    }

    public boolean func_668_j(int i2, int j2, int k2, int l2) {
        int i1 = this.getBlockId(i2, j2, k2);
        if (i1 == 0) {
            return false;
        }
        return Block.allBlocks[i1].isIndirectlyPoweringTo(this, i2, j2, k2, l2);
    }

    public boolean func_646_n(int i2, int j2, int k2) {
        if (this.func_668_j(i2, j2 - 1, k2, 0)) {
            return true;
        }
        if (this.func_668_j(i2, j2 + 1, k2, 1)) {
            return true;
        }
        if (this.func_668_j(i2, j2, k2 - 1, 2)) {
            return true;
        }
        if (this.func_668_j(i2, j2, k2 + 1, 3)) {
            return true;
        }
        if (this.func_668_j(i2 - 1, j2, k2, 4)) {
            return true;
        }
        return this.func_668_j(i2 + 1, j2, k2, 5);
    }

    public boolean isBlockIndirectlyProvidingPowerTo(int i2, int j2, int k2, int l2) {
        if (this.getBlockId(i2, j2, k2) == Block.motor.blockID) {
            return true;
        }
        if (this.isBlockNormalCube(i2, j2, k2) && this.getBlockId(i2, j2, k2) != Block.motor.blockID) {
            return this.func_646_n(i2, j2, k2);
        }
        int i1 = this.getBlockId(i2, j2, k2);
        if (i1 == 0) {
            return false;
        }
        return Block.allBlocks[i1].isPoweringTo(this, i2, j2, k2, l2);
    }

    public boolean isBlockIndirectlyGettingPowered(int i2, int j2, int k2) {
        if (this.isBlockIndirectlyProvidingPowerTo(i2, j2 - 1, k2, 0)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i2, j2 + 1, k2, 1)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 - 1, 2)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 + 1, 3)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i2 - 1, j2, k2, 4)) {
            return true;
        }
        return this.isBlockIndirectlyProvidingPowerTo(i2 + 1, j2, k2, 5);
    }

    public EntityPlayer getClosestPlayerToEntity(Entity entity, double d2) {
        return this.getClosestPlayer(entity.posX, entity.posY, entity.posZ, d2);
    }

    public EntityPlayer getClosestPlayer(double d2, double d1, double d22, double d3) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        int i2 = 0;
        while (i2 < this.playerEntities.size()) {
            EntityPlayer entityplayer1 = this.playerEntities.get(i2);
            double d5 = entityplayer1.getDistanceSq(d2, d1, d22);
            if ((d3 < 0.0 || d5 < d3 * d3) && (d4 == -1.0 || d5 < d4)) {
                d4 = d5;
                entityplayer = entityplayer1;
            }
            ++i2;
        }
        return entityplayer;
    }

    public void setChunkData(int xPos, int yPos, int zPos, int xSize, int ySize, int zSize, byte[] chunk) {
        int chunkPosXMin = xPos >> 4;
        int chunkPosZMin = zPos >> 4;
        int chunkPosXMax = xPos + xSize - 1 >> 4;
        int chunkPosZMax = zPos + zSize - 1 >> 4;
        int k2 = 0;
        int chunkPosYMin = yPos;
        int chunkPosYMax = yPos + ySize;
        if (chunkPosYMin < 0) {
            chunkPosYMin = 0;
        }
        if (chunkPosYMax > 128) {
            chunkPosYMax = 128;
        }
        int xIndex = chunkPosXMin;
        while (xIndex <= chunkPosXMax) {
            int k3 = xPos - xIndex * 16;
            int l3 = xPos + xSize - xIndex * 16;
            if (k3 < 0) {
                k3 = 0;
            }
            if (l3 > 16) {
                l3 = 16;
            }
            int zIndex = chunkPosZMin;
            while (zIndex <= chunkPosZMax) {
                int j4 = zPos - zIndex * 16;
                int k4 = zPos + zSize - zIndex * 16;
                if (j4 < 0) {
                    j4 = 0;
                }
                if (k4 > 16) {
                    k4 = 16;
                }
                k2 = this.getChunkFromChunkCoords(xIndex, zIndex).getChunkData(chunk, k3, chunkPosYMin, j4, l3, chunkPosYMax, k4, k2);
                this.markBlocksDirty(xIndex * 16 + k3, chunkPosYMin, zIndex * 16 + j4, xIndex * 16 + l3, chunkPosYMax, zIndex * 16 + k4);
                ++zIndex;
            }
            ++xIndex;
        }
    }

    public void sendQuittingDisconnectingPacket() {
    }

    public void checkSessionLock() {
        try {
            File file = new File(this.worldFolder, "session.lock");
            DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));
            try {
                if (datainputstream.readLong() != this.field_1018_G) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
            finally {
                datainputstream.close();
            }
        }
        catch (IOException ioexception) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    public void setWorldTime(long l2) {
        this.worldTime = l2;
    }

    public void func_705_f(Entity entity) {
        int i2 = MathHelper.floor_double(entity.posX / 16.0);
        int j2 = MathHelper.floor_double(entity.posZ / 16.0);
        int byte0 = 2;
        int k2 = i2 - byte0;
        while (k2 <= i2 + byte0) {
            int l2 = j2 - byte0;
            while (l2 <= j2 + byte0) {
                this.getChunkFromChunkCoords(k2, l2);
                ++l2;
            }
            ++k2;
        }
        if (!this.loadedEntityList.contains(entity)) {
            System.out.println("REINSERTING PLAYER!");
            this.loadedEntityList.add(entity);
            this.obtainEntitySkin(entity);
        }
    }

    public void func_28106_e(int i2, int j2, int k2, int l2, int i1) {
        this.func_28107_a(null, i2, j2, k2, l2, i1);
    }

    public void func_28107_a(EntityPlayer entityplayer, int i2, int j2, int k2, int l2, int i1) {
        int j1 = 0;
        while (j1 < this.worldAccesses.size()) {
            this.worldAccesses.get(j1).func_28136_a(entityplayer, i2, j2, k2, l2, i1);
            ++j1;
        }
    }
}

