/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.tile;

import com.mojang.minecraft.entity.EntityList;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;

public class TileEntityMobSpawner
extends TileEntity {
    public int delay = 20;
    public String entityID = "Pig";
    public double field_831_c;
    public double field_830_d = 0.0;

    public boolean func_484_a() {
        return this.world.getClosestPlayer((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, 16.0) != null;
    }

    public void func_475_b() {
        this.field_830_d = this.field_831_c;
        if (!this.func_484_a()) {
            return;
        }
        double d2 = (float)this.x + this.world.rand.nextFloat();
        double d22 = (float)this.y + this.world.rand.nextFloat();
        double d4 = (float)this.z + this.world.rand.nextFloat();
        this.world.spawnParticle("smoke", d2, d22, d4, 0.0, 0.0, 0.0);
        this.world.spawnParticle("flame", d2, d22, d4, 0.0, 0.0, 0.0);
        this.field_831_c += (double)(1000.0f / ((float)this.delay + 200.0f));
        while (this.field_831_c > 360.0) {
            this.field_831_c -= 360.0;
            this.field_830_d -= 360.0;
        }
        if (this.delay == -1) {
            this.func_483_c();
        }
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        int byte0 = 4;
        int i2 = 0;
        while (i2 < byte0) {
            EntityLiving entityliving = (EntityLiving)EntityList.createEntityByIdFromName(this.entityID, this.world);
            if (entityliving == null || this.world.multiplayerWorld) {
                return;
            }
            int j2 = this.world.getEntitiesWithinAABB(entityliving.getClass(), AxisAlignedBB.getBoundingBoxFromPool(this.x, this.y, this.z, this.x + 1, this.y + 1, this.z + 1).expand(8.0, 4.0, 8.0)).size();
            if (j2 >= 6) {
                this.func_483_c();
                return;
            }
            double d6 = (double)this.x + (this.world.rand.nextDouble() - this.world.rand.nextDouble()) * 4.0;
            double d7 = this.y + this.world.rand.nextInt(3) - 1;
            double d8 = (double)this.z + (this.world.rand.nextDouble() - this.world.rand.nextDouble()) * 4.0;
            entityliving.setLocationAndAngles(d6, d7, d8, this.world.rand.nextFloat() * 360.0f, 0.0f);
            if (entityliving.func_433_a()) {
                this.world.entityJoinedWorld(entityliving);
                this.world.playSoundEffect(this.x, this.y, this.z, "random.breath", 1.0f, 1.0f);
                int k2 = 0;
                while (k2 < 20) {
                    double d1 = (double)this.x + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                    double d3 = (double)this.y + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                    double d5 = (double)this.z + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                    this.world.spawnParticle("smoke", d1, d3, d5, 0.0, 0.0, 0.0);
                    this.world.spawnParticle("flame", d1, d3, d5, 0.0, 0.0, 0.0);
                    ++k2;
                }
                entityliving.func_415_z();
                this.func_483_c();
            }
            ++i2;
        }
        super.func_475_b();
    }

    private void func_483_c() {
        this.delay = 200 + this.world.rand.nextInt(600);
    }

    public void func_482_a(NBTTagCompound nbttagcompound) {
        super.func_482_a(nbttagcompound);
        this.entityID = nbttagcompound.getString("EntityId");
        this.delay = nbttagcompound.getShort("Delay");
    }

    public void func_481_b(NBTTagCompound nbttagcompound) {
        super.func_481_b(nbttagcompound);
        nbttagcompound.setString("EntityId", this.entityID);
        nbttagcompound.setShort("Delay", (short)this.delay);
    }

    public String getEntityID() {
        return this.entityID;
    }
}

