/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;

public class ItemHoe
extends Item {
    public ItemHoe(int i2, int j2) {
        super(i2);
        this.maxStackSize = 1;
        this.maxDamage = 32 << j2;
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i2, int j2, int k2, int l2) {
        int i1 = world.getBlockId(i2, j2, k2);
        Material material = world.getMaterialXYZ(i2, j2 + 1, k2);
        if (!material.isSolidMaterial() && i1 == Block.grass.blockID || i1 == Block.dirt.blockID) {
            Block block = Block.tilledField;
            world.playSoundEffect((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
            if (world.multiplayerWorld) {
                return true;
            }
            world.setBlockWithNotify(i2, j2, k2, block.blockID);
            itemstack.damageItem(1);
            if (world.rand.nextInt(8) == 0 && i1 == Block.grass.blockID) {
                int j1 = 1;
                int k1 = 0;
                while (k1 < j1) {
                    float f2 = 0.7f;
                    float f1 = world.rand.nextFloat() * f2 + (1.0f - f2) * 0.5f;
                    float f22 = 1.2f;
                    float f3 = world.rand.nextFloat() * f2 + (1.0f - f2) * 0.5f;
                    EntityItem entityitem = new EntityItem(world, (float)i2 + f1, (float)j2 + f22, (float)k2 + f3, new ItemStack(Item.seeds));
                    entityitem.delayBeforeCanPickup = 10;
                    world.entityJoinedWorld(entityitem);
                    ++k1;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_194_a() {
        return true;
    }
}

