/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.generate.IChunkLoader;
import com.mojang.minecraft.level.generate.IChunkProvider;
import java.io.IOException;

public class ChunkProviderLoadOrGenerate
implements IChunkProvider {
    private Chunk localChunk;
    private IChunkProvider chunkProvider;
    private IChunkLoader chunkLoader;
    private Chunk[] chunks = new Chunk[1024];
    private World worldObj;
    int chunkX = -999999999;
    int chunkZ = -999999999;
    private Chunk workingChunk;
    private int curChunkX;
    private int curChunkY;

    public ChunkProviderLoadOrGenerate(World world, IChunkLoader ichunkloader, IChunkProvider ichunkprovider) {
        this.localChunk = new Chunk(world, new byte[32768], 0, 0);
        this.localChunk.hasEntities2 = true;
        this.localChunk.neverSave = true;
        this.worldObj = world;
        this.chunkLoader = ichunkloader;
        this.chunkProvider = ichunkprovider;
    }

    public void setCurrentChunkOver(int x, int z) {
        this.curChunkX = x;
        this.curChunkY = z;
    }

    public boolean canChunkExist(int x, int z) {
        int byte0 = 15;
        return x >= this.curChunkX - byte0 && z >= this.curChunkY - byte0 && x <= this.curChunkX + byte0 && z <= this.curChunkY + byte0;
    }

    public boolean chunkExists(int x, int z) {
        if (x == this.chunkX && z == this.chunkZ && this.workingChunk != null) {
            return true;
        }
        int k = x & 0x1F;
        int l = z & 0x1F;
        int i1 = k + l * 32;
        return this.chunks[i1] != null && (this.chunks[i1] == this.localChunk || this.chunks[i1].isAtLocation(x, z));
    }

    public Chunk provideChunk(int x, int j) {
        if (x == this.chunkX && j == this.chunkZ && this.workingChunk != null) {
            return this.workingChunk;
        }
        int k = x & 0x1F;
        int l = j & 0x1F;
        int i1 = k + l * 32;
        if (!this.chunkExists(x, j)) {
            Chunk chunk;
            if (this.chunks[i1] != null) {
                this.chunks[i1].onChunkUnload();
                this.saveLoadedChunk(this.chunks[i1]);
                this.saveLoadedChunkData(this.chunks[i1]);
            }
            if ((chunk = this.provideLoadedChunk(x, j)) == null) {
                chunk = this.chunkProvider == null ? this.localChunk : this.chunkProvider.provideChunk(x, j);
            }
            this.chunks[i1] = chunk;
            if (this.chunks[i1] != null) {
                this.chunks[i1].onChunkLoad();
            }
            if (!this.chunks[i1].isTerrainPopulated && this.chunkExists(x + 1, j + 1) && this.chunkExists(x, j + 1) && this.chunkExists(x + 1, j)) {
                this.generateStructures(this, x, j);
            }
            if (this.chunkExists(x - 1, j) && !this.provideChunk((int)(x - 1), (int)j).isTerrainPopulated && this.chunkExists(x - 1, j + 1) && this.chunkExists(x, j + 1) && this.chunkExists(x - 1, j)) {
                this.generateStructures(this, x - 1, j);
            }
            if (this.chunkExists(x, j - 1) && !this.provideChunk((int)x, (int)(j - 1)).isTerrainPopulated && this.chunkExists(x + 1, j - 1) && this.chunkExists(x, j - 1) && this.chunkExists(x + 1, j)) {
                this.generateStructures(this, x, j - 1);
            }
            if (this.chunkExists(x - 1, j - 1) && !this.provideChunk((int)(x - 1), (int)(j - 1)).isTerrainPopulated && this.chunkExists(x - 1, j - 1) && this.chunkExists(x, j - 1) && this.chunkExists(x - 1, j)) {
                this.generateStructures(this, x - 1, j - 1);
            }
        }
        this.chunkX = x;
        this.chunkZ = j;
        this.workingChunk = this.chunks[i1];
        return this.chunks[i1];
    }

    private Chunk provideLoadedChunk(int i, int j) {
        if (this.chunkLoader == null) {
            return null;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunkFromFile(this.worldObj, i, j);
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.worldTime;
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void saveLoadedChunkData(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            this.chunkLoader.saveExtraChunkData(this.worldObj, chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveLoadedChunk(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.worldObj.worldTime;
            this.chunkLoader.saveChunk(this.worldObj, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public void generateStructures(IChunkProvider ichunkprovider, int i, int j) {
        Chunk chunk = this.provideChunk(i, j);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.generateStructures(ichunkprovider, i, j);
                chunk.setChunkModified();
            }
        }
    }

    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        int i = 0;
        int j = 0;
        if (iprogressupdate != null) {
            int k = 0;
            while (k < this.chunks.length) {
                if (this.chunks[k] != null && this.chunks[k].needsSaving(flag)) {
                    ++j;
                }
                ++k;
            }
        }
        int l = 0;
        int i1 = 0;
        while (i1 < this.chunks.length) {
            if (this.chunks[i1] != null) {
                if (flag && !this.chunks[i1].neverSave) {
                    this.saveLoadedChunkData(this.chunks[i1]);
                }
                if (this.chunks[i1].needsSaving(flag)) {
                    this.saveLoadedChunk(this.chunks[i1]);
                    this.chunks[i1].isModified = false;
                    if (++i == 2 && !flag) {
                        return false;
                    }
                    if (iprogressupdate != null && ++l % 10 == 0) {
                        iprogressupdate.setProgess(l * 100 / j);
                    }
                }
            }
            ++i1;
        }
        if (flag) {
            if (this.chunkLoader == null) {
                return true;
            }
            this.chunkLoader.saveExtraData();
        }
        return true;
    }

    public boolean unload100OldestChunks() {
        if (this.chunkLoader != null) {
            this.chunkLoader.func_814_a();
        }
        return this.chunkProvider.unload100OldestChunks();
    }

    public boolean canSave() {
        return true;
    }
}

