/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;

public class EntityBoat
extends Entity {
    public int boatCurrentDamage = 0;
    public int boatTimeSinceHit = 0;
    public int boatRockDirection = 1;
    private int field_9394_d;
    private double field_9393_e;
    private double field_9392_f;
    private double field_9391_g;
    private double field_9390_h;
    private double field_9389_i;
    private double field_9388_j;
    private double field_9387_k;
    private double field_9386_l;

    public EntityBoat(World world) {
        super(world);
        this.preventEntitySpawning = true;
        this.setSize(1.5f, 0.6f);
        this.yOffset = this.height / 2.0f;
        this.field_640_aG = false;
    }

    protected void entityInit() {
    }

    public AxisAlignedBB getCollisionBox(Entity entity) {
        return entity.boundingBox;
    }

    public AxisAlignedBB func_372_f_() {
        return this.boundingBox;
    }

    public boolean canBePushed() {
        return true;
    }

    public EntityBoat(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1 + (double)this.yOffset, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.0 - (double)0.3f;
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        if (this.worldObj.multiplayerWorld || this.isDead) {
            return true;
        }
        this.boatRockDirection = -this.boatRockDirection;
        this.boatTimeSinceHit = 10;
        this.boatCurrentDamage += i * 10;
        if (this.boatCurrentDamage > 40) {
            if (!this.worldObj.multiplayerWorld) {
                this.dropItemWithOffset(Item.boat.shiftedIndex, 1, 0.0f);
            }
            this.setEntityDead();
        }
        return true;
    }

    public void performHurtAnimation() {
        this.boatRockDirection = -this.boatRockDirection;
        this.boatTimeSinceHit = 10;
        this.boatCurrentDamage += this.boatCurrentDamage * 10;
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public void onUpdate() {
        double d4;
        super.onUpdate();
        if (this.boatTimeSinceHit > 0) {
            --this.boatTimeSinceHit;
        }
        if (this.boatCurrentDamage > 0) {
            --this.boatCurrentDamage;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        int i = 5;
        double d = 0.0;
        int j = 0;
        while (j < i) {
            double d5 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(j + 0) / (double)i - 0.125;
            double d9 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(j + 1) / (double)i - 0.125;
            AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBoxFromPool(this.boundingBox.minX, d5, this.boundingBox.minZ, this.boundingBox.maxX, d9, this.boundingBox.maxZ);
            if (this.worldObj.isAABBInMaterial(axisalignedbb, Material.water)) {
                d += 1.0 / (double)i;
            }
            ++j;
        }
        if (this.worldObj.multiplayerWorld && this.riddenByEntity == null) {
            if (this.field_9394_d > 0) {
                double d1 = this.posX + (this.field_9393_e - this.posX) / (double)this.field_9394_d;
                double d6 = this.posY + (this.field_9392_f - this.posY) / (double)this.field_9394_d;
                double d10 = this.posZ + (this.field_9391_g - this.posZ) / (double)this.field_9394_d;
                double d14 = this.field_9390_h - (double)this.rotationYaw;
                while (d14 < -180.0) {
                    d14 += 360.0;
                }
                while (d14 >= 180.0) {
                    d14 -= 360.0;
                }
                this.rotationYaw = (float)((double)this.rotationYaw + d14 / (double)this.field_9394_d);
                this.rotationPitch = (float)((double)this.rotationPitch + (this.field_9389_i - (double)this.rotationPitch) / (double)this.field_9394_d);
                --this.field_9394_d;
                this.setPosition(d1, d6, d10);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                double d2 = this.posX + this.motionX;
                double d7 = this.posY + this.motionY;
                double d11 = this.posZ + this.motionZ;
                this.setPosition(d2, d7, d11);
                if (this.onGround) {
                    this.motionX *= 0.5;
                    this.motionY *= 0.5;
                    this.motionZ *= 0.5;
                }
                this.motionX *= (double)0.99f;
                this.motionY *= (double)0.95f;
                this.motionZ *= (double)0.99f;
            }
            return;
        }
        double d3 = d * 2.0 - 1.0;
        this.motionY += (double)0.04f * d3;
        if (this.riddenByEntity != null) {
            this.motionX += this.riddenByEntity.motionX * 0.4;
            this.motionZ += this.riddenByEntity.motionZ * 0.4;
        }
        if (this.motionX < -(d4 = 0.4)) {
            this.motionX = -d4;
        }
        if (this.motionX > d4) {
            this.motionX = d4;
        }
        if (this.motionZ < -d4) {
            this.motionZ = -d4;
        }
        if (this.motionZ > d4) {
            this.motionZ = d4;
        }
        if (this.onGround) {
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        double d8 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        if (d8 > 0.15) {
            double d12 = Math.cos((double)this.rotationYaw * Math.PI / 180.0);
            double d15 = Math.sin((double)this.rotationYaw * Math.PI / 180.0);
            int i1 = 0;
            while ((double)i1 < 1.0 + d8 * 60.0) {
                double d18 = this.rand.nextFloat() * 2.0f - 1.0f;
                double d20 = (double)(this.rand.nextInt(2) * 2 - 1) * 0.7;
                if (this.rand.nextBoolean()) {
                    double d21 = this.posX - d12 * d18 * 0.8 + d15 * d20;
                    double d23 = this.posZ - d15 * d18 * 0.8 - d12 * d20;
                    this.worldObj.spawnParticle("splash", d21, this.posY - 0.125, d23, this.motionX, this.motionY, this.motionZ);
                } else {
                    double d22 = this.posX + d12 + d15 * d18 * 0.7;
                    double d24 = this.posZ + d15 - d12 * d18 * 0.7;
                    this.worldObj.spawnParticle("splash", d22, this.posY - 0.125, d24, this.motionX, this.motionY, this.motionZ);
                }
                ++i1;
            }
        }
        if (!this.isCollidedHorizionally || !(d8 > 0.15)) {
            this.motionX *= (double)0.99f;
            this.motionY *= (double)0.95f;
            this.motionZ *= (double)0.99f;
        }
        this.rotationPitch = 0.0f;
        double d13 = this.rotationYaw;
        double d16 = this.prevPosX - this.posX;
        double d17 = this.prevPosZ - this.posZ;
        if (d16 * d16 + d17 * d17 > 0.001) {
            d13 = (float)(Math.atan2(d17, d16) * 180.0 / Math.PI);
        }
        double d19 = d13 - (double)this.rotationYaw;
        while (d19 >= 180.0) {
            d19 -= 360.0;
        }
        while (d19 < -180.0) {
            d19 += 360.0;
        }
        if (d19 > 20.0) {
            d19 = 20.0;
        }
        if (d19 < -20.0) {
            d19 = -20.0;
        }
        this.rotationYaw = (float)((double)this.rotationYaw + d19);
        this.setRotation(this.rotationYaw, this.rotationPitch);
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            int j1 = 0;
            while (j1 < list.size()) {
                Entity entity = list.get(j1);
                if (entity != this.riddenByEntity && entity.canBePushed() && entity instanceof EntityBoat) {
                    entity.applyEntityCollision(this);
                }
                ++j1;
            }
        }
        int k1 = 0;
        while (k1 < 4) {
            int j2;
            int i2;
            int l1 = MathHelper.floor_double(this.posX + ((double)(k1 % 2) - 0.5) * 0.8);
            if (this.worldObj.getBlockId(l1, i2 = MathHelper.floor_double(this.posY), j2 = MathHelper.floor_double(this.posZ + ((double)(k1 / 2) - 0.5) * 0.8)) == Block.snow.blockID) {
                this.worldObj.setBlockWithNotify(l1, i2, j2, 0);
            }
            ++k1;
        }
        if (this.riddenByEntity != null && this.riddenByEntity.isDead) {
            this.riddenByEntity = null;
        }
    }

    protected void updateRiderPosition() {
        if (this.riddenByEntity == null) {
            return;
        }
        double d = Math.cos((double)this.rotationYaw * Math.PI / 180.0) * 0.4;
        double d1 = Math.sin((double)this.rotationYaw * Math.PI / 180.0) * 0.4;
        this.riddenByEntity.setPosition(this.posX + d, this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset(), this.posZ + d1);
    }

    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
    }

    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
    }

    public float getShadowSize() {
        return 0.0f;
    }

    public boolean interact(EntityPlayer entityplayer) {
        if (!this.worldObj.multiplayerWorld) {
            entityplayer.mountEntity(this);
        }
        return true;
    }
}

