/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.level.tile.fx.TextureFX;
import com.mojang.minecraft.player.controller.GameSettings;
import com.mojang.minecraft.render.GLAllocation;
import com.mojang.minecraft.render.ImageBuffer;
import com.mojang.minecraft.util.DownloadImageThreadData;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;

public class RenderEngine {
    public static boolean useMipMaps = false;
    private HashMap<String, Integer> textureMap = new HashMap();
    private HashMap<Integer, BufferedImage> field_1607_c = new HashMap();
    private IntBuffer field_1606_d = GLAllocation.createDirectIntBuffer(1);
    private ByteBuffer field_1605_e = GLAllocation.createDirectByteBuffer(0x100000);
    private List<TextureFX> field_1604_f = new ArrayList<TextureFX>();
    private Map<String, DownloadImageThreadData> field_1603_g = new HashMap<String, DownloadImageThreadData>();
    private GameSettings field_1602_h;
    private boolean field_1601_i = false;

    public RenderEngine(GameSettings gamesettings) {
        this.field_1602_h = gamesettings;
    }

    public int getTex(String s) {
        Integer integer = this.textureMap.get(s);
        if (integer != null) {
            return integer;
        }
        try {
            this.field_1606_d.clear();
            GLAllocation.func_1128_a(this.field_1606_d);
            int i = this.field_1606_d.get(0);
            if (s.startsWith("##")) {
                this.func_1068_a(this.func_1069_b(ImageIO.read(RenderEngine.class.getResourceAsStream(s.substring(2)))), i);
            } else if (s.startsWith("%%")) {
                this.field_1601_i = true;
                this.func_1068_a(ImageIO.read(RenderEngine.class.getResourceAsStream(s.substring(2))), i);
                this.field_1601_i = false;
            } else {
                this.func_1068_a(ImageIO.read(RenderEngine.class.getResourceAsStream(s)), i);
            }
            this.textureMap.put(s, i);
            return i;
        }
        catch (IOException ioexception) {
            throw new RuntimeException("!!");
        }
    }

    private BufferedImage func_1069_b(BufferedImage bufferedimage) {
        int i = bufferedimage.getWidth() / 16;
        BufferedImage bufferedimage1 = new BufferedImage(16, bufferedimage.getHeight() * i, 2);
        Graphics g = bufferedimage1.getGraphics();
        int j = 0;
        while (j < i) {
            g.drawImage(bufferedimage, -j * 16, j * bufferedimage.getHeight(), null);
            ++j;
        }
        g.dispose();
        return bufferedimage1;
    }

    public int func_1074_a(BufferedImage bufferedimage) {
        this.field_1606_d.clear();
        GLAllocation.func_1128_a(this.field_1606_d);
        int i = this.field_1606_d.get(0);
        this.func_1068_a(bufferedimage, i);
        this.field_1607_c.put(i, bufferedimage);
        return i;
    }

    public void func_1068_a(BufferedImage bufferedimage, int i) {
        GL11.glBindTexture((int)3553, (int)i);
        if (useMipMaps) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (this.field_1601_i) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        int j = bufferedimage.getWidth();
        int k = bufferedimage.getHeight();
        int[] ai = new int[j * k];
        byte[] abyte0 = new byte[j * k * 4];
        bufferedimage.getRGB(0, 0, j, k, ai, 0, j);
        int l = 0;
        while (l < ai.length) {
            int j1 = ai[l] >> 24 & 0xFF;
            int l1 = ai[l] >> 16 & 0xFF;
            int j2 = ai[l] >> 8 & 0xFF;
            int l2 = ai[l] & 0xFF;
            if (this.field_1602_h != null && this.field_1602_h.anaglyph) {
                int j3 = (l1 * 30 + j2 * 59 + l2 * 11) / 100;
                int l3 = (l1 * 30 + j2 * 70) / 100;
                int j4 = (l1 * 30 + l2 * 70) / 100;
                l1 = j3;
                j2 = l3;
                l2 = j4;
            }
            abyte0[l * 4 + 0] = (byte)l1;
            abyte0[l * 4 + 1] = (byte)j2;
            abyte0[l * 4 + 2] = (byte)l2;
            abyte0[l * 4 + 3] = (byte)j1;
            ++l;
        }
        this.field_1605_e.clear();
        this.field_1605_e.put(abyte0);
        this.field_1605_e.position(0).limit(abyte0.length);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)j, (int)k, (int)0, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
        if (useMipMaps) {
            int i1 = 1;
            while (i1 <= 4) {
                int k1 = j >> i1 - 1;
                int i2 = j >> i1;
                int k2 = k >> i1;
                int i3 = 0;
                while (i3 < i2) {
                    int k3 = 0;
                    while (k3 < k2) {
                        int i4 = this.field_1605_e.getInt((i3 * 2 + 0 + (k3 * 2 + 0) * k1) * 4);
                        int k4 = this.field_1605_e.getInt((i3 * 2 + 1 + (k3 * 2 + 0) * k1) * 4);
                        int l4 = this.field_1605_e.getInt((i3 * 2 + 1 + (k3 * 2 + 1) * k1) * 4);
                        int i5 = this.field_1605_e.getInt((i3 * 2 + 0 + (k3 * 2 + 1) * k1) * 4);
                        int j5 = this.func_1077_b(this.func_1077_b(i4, k4), this.func_1077_b(l4, i5));
                        this.field_1605_e.putInt((i3 + k3 * i2) * 4, j5);
                        ++k3;
                    }
                    ++i3;
                }
                GL11.glTexImage2D((int)3553, (int)i1, (int)6408, (int)i2, (int)k2, (int)0, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
                ++i1;
            }
        }
    }

    public void func_1078_a(int i) {
        this.field_1607_c.remove(i);
        this.field_1606_d.clear();
        this.field_1606_d.put(i);
        this.field_1606_d.flip();
        GL11.glDeleteTextures((IntBuffer)this.field_1606_d);
    }

    public int func_1071_a(String s, String s1) {
        DownloadImageThreadData downloadimagethreaddata = this.field_1603_g.get(s);
        if (downloadimagethreaddata != null && downloadimagethreaddata.field_1706_a != null && !downloadimagethreaddata.field_1707_d) {
            if (downloadimagethreaddata.field_1708_c < 0) {
                downloadimagethreaddata.field_1708_c = this.func_1074_a(downloadimagethreaddata.field_1706_a);
            } else {
                this.func_1068_a(downloadimagethreaddata.field_1706_a, downloadimagethreaddata.field_1708_c);
            }
            downloadimagethreaddata.field_1707_d = true;
        }
        if (downloadimagethreaddata == null || downloadimagethreaddata.field_1708_c < 0) {
            return this.getTex(s1);
        }
        return downloadimagethreaddata.field_1708_c;
    }

    public DownloadImageThreadData func_1075_a(String s, ImageBuffer imagebuffer) {
        DownloadImageThreadData downloadimagethreaddata = this.field_1603_g.get(s);
        if (downloadimagethreaddata == null) {
            this.field_1603_g.put(s, new DownloadImageThreadData(s, imagebuffer));
        } else {
            ++downloadimagethreaddata.field_1705_b;
        }
        return downloadimagethreaddata;
    }

    public void func_1073_b(String s) {
        DownloadImageThreadData downloadimagethreaddata = this.field_1603_g.get(s);
        if (downloadimagethreaddata != null) {
            --downloadimagethreaddata.field_1705_b;
            if (downloadimagethreaddata.field_1705_b == 0) {
                if (downloadimagethreaddata.field_1708_c >= 0) {
                    this.func_1078_a(downloadimagethreaddata.field_1708_c);
                }
                this.field_1603_g.remove(s);
            }
        }
    }

    public void bindTextureFX(TextureFX texturefx) {
        this.field_1604_f.add(texturefx);
        texturefx.render();
    }

    public void attachTextureFX() {
        int i = 0;
        while (i < this.field_1604_f.size()) {
            TextureFX texturefx = this.field_1604_f.get(i);
            texturefx.field_1131_c = this.field_1602_h.anaglyph;
            texturefx.render();
            this.field_1605_e.clear();
            this.field_1605_e.put(texturefx.field_1127_a);
            this.field_1605_e.position(0).limit(texturefx.field_1127_a.length);
            texturefx.bindTextureFXToTexture(this);
            int texFXU = 0;
            while (texFXU < texturefx.prevSize) {
                int texFXV = 0;
                while (texFXV < texturefx.prevSize) {
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)(texturefx.texIndex % 16 * 16 + texFXU * 16), (int)(texturefx.texIndex / 16 * 16 + texFXV * 16), (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
                    if (useMipMaps) {
                        for (int k1 = 1; k1 <= 4; ++k1) {
                            int i2 = 16 >> k1 - 1;
                            int k2 = 16 >> k1;
                            int i3 = 0;
                            while (i3 < k2) {
                                int k3 = 0;
                                while (k3 < k2) {
                                    int i4 = this.field_1605_e.getInt((i3 * 2 + 0 + (k3 * 2 + 0) * i2) * 4);
                                    int k4 = this.field_1605_e.getInt((i3 * 2 + 1 + (k3 * 2 + 0) * i2) * 4);
                                    int i5 = this.field_1605_e.getInt((i3 * 2 + 1 + (k3 * 2 + 1) * i2) * 4);
                                    int k5 = this.field_1605_e.getInt((i3 * 2 + 0 + (k3 * 2 + 1) * i2) * 4);
                                    int l5 = this.func_1072_a(this.func_1072_a(i4, k4), this.func_1072_a(i5, k5));
                                    this.field_1605_e.putInt((i3 + k3 * k2) * 4, l5);
                                    ++k3;
                                }
                                ++i3;
                            }
                            GL11.glTexSubImage2D((int)3553, (int)k1, (int)(texturefx.texIndex % 16 * k2), (int)(texturefx.texIndex / 16 * k2), (int)k2, (int)k2, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
                        }
                    }
                    ++texFXV;
                }
                ++texFXU;
            }
            ++i;
        }
        int j = 0;
        while (j < this.field_1604_f.size()) {
            TextureFX texturefx1 = this.field_1604_f.get(j);
            if (texturefx1.size > 0) {
                this.field_1605_e.clear();
                this.field_1605_e.put(texturefx1.field_1127_a);
                this.field_1605_e.position(0).limit(texturefx1.field_1127_a.length);
                GL11.glBindTexture((int)3553, (int)texturefx1.size);
                GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
                if (useMipMaps) {
                    for (int l = 1; l <= 4; ++l) {
                        int j1 = 16 >> l - 1;
                        int l1 = 16 >> l;
                        int j2 = 0;
                        while (j2 < l1) {
                            int l2 = 0;
                            while (l2 < l1) {
                                int j3 = this.field_1605_e.getInt((j2 * 2 + 0 + (l2 * 2 + 0) * j1) * 4);
                                int l3 = this.field_1605_e.getInt((j2 * 2 + 1 + (l2 * 2 + 0) * j1) * 4);
                                int j4 = this.field_1605_e.getInt((j2 * 2 + 1 + (l2 * 2 + 1) * j1) * 4);
                                int l4 = this.field_1605_e.getInt((j2 * 2 + 0 + (l2 * 2 + 1) * j1) * 4);
                                int j5 = this.func_1072_a(this.func_1072_a(j3, l3), this.func_1072_a(j4, l4));
                                this.field_1605_e.putInt((j2 + l2 * l1) * 4, j5);
                                ++l2;
                            }
                            ++j2;
                        }
                        GL11.glTexSubImage2D((int)3553, (int)l, (int)0, (int)0, (int)l1, (int)l1, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
                    }
                }
            }
            ++j;
        }
    }

    private int func_1072_a(int i, int j) {
        int k = (i & 0xFF000000) >> 24 & 0xFF;
        int l = (j & 0xFF000000) >> 24 & 0xFF;
        return (k + l >> 1 << 24) + ((i & 0xFEFEFE) + (j & 0xFEFEFE) >> 1);
    }

    private int func_1077_b(int i, int j) {
        int k = (i & 0xFF000000) >> 24 & 0xFF;
        int l = (j & 0xFF000000) >> 24 & 0xFF;
        int c = 255;
        if (k + l == 0) {
            k = 1;
            l = 1;
            c = 0;
        }
        int i1 = (i >> 16 & 0xFF) * k;
        int j1 = (i >> 8 & 0xFF) * k;
        int k1 = (i & 0xFF) * k;
        int l1 = (j >> 16 & 0xFF) * l;
        int i2 = (j >> 8 & 0xFF) * l;
        int j2 = (j & 0xFF) * l;
        int k2 = (i1 + l1) / (k + l);
        int l2 = (j1 + i2) / (k + l);
        int i3 = (k1 + j2) / (k + l);
        return c << 24 | k2 << 16 | l2 << 8 | i3;
    }

    public void func_1065_b() {
        for (int i : this.field_1607_c.keySet()) {
            BufferedImage bufferedimage = this.field_1607_c.get(i);
            this.func_1068_a(bufferedimage, i);
        }
        for (DownloadImageThreadData downloadimagethreaddata : this.field_1603_g.values()) {
            downloadimagethreaddata.field_1707_d = false;
        }
        for (String s : this.textureMap.keySet()) {
            try {
                BufferedImage bufferedimage1;
                if (s.startsWith("##")) {
                    bufferedimage1 = this.func_1069_b(ImageIO.read(RenderEngine.class.getResourceAsStream(s.substring(2))));
                } else if (s.startsWith("%%")) {
                    this.field_1601_i = true;
                    bufferedimage1 = ImageIO.read(RenderEngine.class.getResourceAsStream(s.substring(2)));
                    this.field_1601_i = false;
                } else {
                    bufferedimage1 = ImageIO.read(RenderEngine.class.getResourceAsStream(s));
                }
                int j = this.textureMap.get(s);
                this.func_1068_a(bufferedimage1, j);
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
    }

    public void bindTex(int i) {
        if (i < 0) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)i);
    }
}

