/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.Random;

public class BlockTorch
extends Block {
    protected BlockTorch(int i, int j) {
        super(i, j, Material.circuits);
        this.setTickOnLoad(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 2;
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        if (world.getBlockId(i, j - 1, k) == Block.fence.blockID || world.getBlockId(i, j - 1, k) == Block.glass.blockID) {
            return true;
        }
        if (world.isBlockNormalCube(i - 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            return true;
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            return true;
        }
        return world.isBlockNormalCube(i, j - 1, k);
    }

    @Override
    public void onBlockPlaced(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        if (l == 1 && (world.isBlockNormalCube(i, j - 1, k) || world.getBlockId(i, j - 1, k) == Block.fence.blockID)) {
            i1 = 5;
        }
        if (l == 2 && world.isBlockNormalCube(i, j, k + 1)) {
            i1 = 4;
        }
        if (l == 3 && world.isBlockNormalCube(i, j, k - 1)) {
            i1 = 3;
        }
        if (l == 4 && world.isBlockNormalCube(i + 1, j, k)) {
            i1 = 2;
        }
        if (l == 5 && world.isBlockNormalCube(i - 1, j, k)) {
            i1 = 1;
        }
        world.setBlockMetadataWithNotify(i, j, k, i1);
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        super.updateTick(world, i, j, k, random);
        if (world.getBlockMetadata(i, j, k) == 0) {
            this.onBlockAdded(world, i, j, k);
        }
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        if (world.isBlockNormalCube(i - 1, j, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 1);
        } else if (world.isBlockNormalCube(i + 1, j, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 2);
        } else if (world.isBlockNormalCube(i, j, k - 1)) {
            world.setBlockMetadataWithNotify(i, j, k, 3);
        } else if (world.isBlockNormalCube(i, j, k + 1)) {
            world.setBlockMetadataWithNotify(i, j, k, 4);
        } else if (world.isBlockNormalCube(i, j - 1, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 5);
        }
        this.func_271_h(world, i, j, k);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (this.func_271_h(world, i, j, k)) {
            int i1 = world.getBlockMetadata(i, j, k);
            boolean flag = false;
            if (!world.isBlockNormalCube(i - 1, j, k) && i1 == 1) {
                flag = true;
            }
            if (!world.isBlockNormalCube(i + 1, j, k) && i1 == 2) {
                flag = true;
            }
            if (!world.isBlockNormalCube(i, j, k - 1) && i1 == 3) {
                flag = true;
            }
            if (!world.isBlockNormalCube(i, j, k + 1) && i1 == 4) {
                flag = true;
            }
            if (!world.isBlockNormalCube(i, j - 1, k) && i1 == 5 && world.getBlockId(i, j - 1, k) != Block.fence.blockID) {
                flag = true;
            }
            if (flag) {
                this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
                world.setBlockWithNotify(i, j, k, 0);
            }
        }
    }

    private boolean func_271_h(World world, int i, int j, int k) {
        if (!this.canPlace(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
            return false;
        }
        return true;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        int l = world.getBlockMetadata(i, j, k) & 7;
        float f = 0.15f;
        if (l == 1) {
            this.setBlockBounds(0.0f, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
        } else if (l == 2) {
            this.setBlockBounds(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0f, 0.8f, 0.5f + f);
        } else if (l == 3) {
            this.setBlockBounds(0.5f - f, 0.2f, 0.0f, 0.5f + f, 0.8f, f * 2.0f);
        } else if (l == 4) {
            this.setBlockBounds(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0f);
        } else {
            float f1 = 0.1f;
            this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, 0.6f, 0.5f + f1);
        }
        return super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        int l = world.getBlockMetadata(i, j, k);
        double d = (float)i + 0.5f;
        double d1 = (float)j + 0.7f;
        double d2 = (float)k + 0.5f;
        double d3 = 0.22f;
        double d4 = 0.27f;
        if (l == 1) {
            world.spawnParticle("smoke", d - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (l == 2) {
            world.spawnParticle("smoke", d + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (l == 3) {
            world.spawnParticle("smoke", d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
        } else if (l == 4) {
            world.spawnParticle("smoke", d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
        } else {
            world.spawnParticle("smoke", d, d1, d2, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

