/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityGear;
import com.mojang.minecraft.entity.tile.TileEntityMotor;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockContainer;
import com.mojang.minecraft.level.tile.material.Material;

public class BlockMotor
extends BlockContainer {
    private boolean isMotor;
    private boolean isPowered;
    private int powerLimit;

    protected BlockMotor(int i, int j, Material material1, boolean isMtr, int limit) {
        super(i, j, material1);
        this.isMotor = isMtr;
        this.powerLimit = limit;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        TileEntityMotor motorEntity = (TileEntityMotor)world.getBlockTileEntity(i, j, k);
        motorEntity.onUpdated(world);
        if (this.isMotor) {
            if (l > 0 && Block.allBlocks[l].canProvidePower() && world.isBlockIndirectlyGettingPowered(i, j, k)) {
                this.applyPower(world, i, j, k);
            } else {
                this.removePower(world, i, j, k);
            }
        }
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        world.func_654_a(i, j, k, this.getBlockEntity());
        this.onNeighborBlockChange(world, i, j, k, 0);
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        TileEntityMotor motorEntity = (TileEntityMotor)world.getBlockTileEntity(i, j, k);
        motorEntity.onRemoved(world);
        if (this.isPowered) {
            this.removePower(world, i, j, k);
        }
    }

    public boolean checkPower(World world, int i, int j, int k) {
        TileEntityGear gearEntity = world.getGearAt(i, j, k);
        return world.checkGearPower(gearEntity);
    }

    public void applyPower(World world, int i, int j, int k) {
        TileEntityGear gearEntity = world.getGearAt(i, j, k);
        System.out.println(world.applyGearPower(gearEntity, this.powerLimit));
        this.isPowered = true;
    }

    public void removePower(World world, int i, int j, int k) {
        TileEntityGear gearEntity = world.getGearAt(i, j, k);
        System.out.println(world.removeGearPower(gearEntity, this.powerLimit));
        this.isPowered = false;
    }

    @Override
    public final boolean canProvidePower() {
        return !this.isMotor;
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (this.checkPower((World)iblockaccess, i, j, k) && !this.isMotor) {
            ((World)iblockaccess).markBlocksDirty(i, j, k, i, j, k);
            return true;
        }
        return false;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        if (this.checkPower(world, i, j, k) && !this.isMotor) {
            world.markBlocksDirty(i, j, k, i, j, k);
        }
        return true;
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityMotor();
    }
}

