/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockLadder
extends Block {
    protected BlockLadder(int i, int j) {
        super(i, j, Material.circuits);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        float f = 0.125f;
        if (l == 2) {
            this.setBlockBounds(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (l == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (l == 4) {
            this.setBlockBounds(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (l == 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        float f = 0.125f;
        if (l == 2) {
            this.setBlockBounds(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (l == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (l == 4) {
            this.setBlockBounds(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (l == 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
        return super.getSelectedCollisionBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 8;
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        if (world.isBlockNormalCube(i - 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            return true;
        }
        return world.isBlockNormalCube(i, j, k + 1);
    }

    @Override
    public void onBlockPlaced(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        if ((i1 == 0 || l == 2) && world.isBlockNormalCube(i, j, k + 1)) {
            i1 = 2;
        }
        if ((i1 == 0 || l == 3) && world.isBlockNormalCube(i, j, k - 1)) {
            i1 = 3;
        }
        if ((i1 == 0 || l == 4) && world.isBlockNormalCube(i + 1, j, k)) {
            i1 = 4;
        }
        if ((i1 == 0 || l == 5) && world.isBlockNormalCube(i - 1, j, k)) {
            i1 = 5;
        }
        world.setBlockMetadataWithNotify(i, j, k, i1);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        boolean flag = false;
        if (i1 == 2 && world.isBlockNormalCube(i, j, k + 1)) {
            flag = true;
        }
        if (i1 == 3 && world.isBlockNormalCube(i, j, k - 1)) {
            flag = true;
        }
        if (i1 == 4 && world.isBlockNormalCube(i + 1, j, k)) {
            flag = true;
        }
        if (i1 == 5 && world.isBlockNormalCube(i - 1, j, k)) {
            flag = true;
        }
        if (!flag) {
            this.dropBlockAsItem(world, i, j, k, i1);
            world.setBlockWithNotify(i, j, k, 0);
        }
        super.onNeighborBlockChange(world, i, j, k, l);
    }

    @Override
    public int quantityDropped(Random random) {
        return 1;
    }
}

