/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityGear;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.BlockContainer;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public final class BlockGear
extends BlockContainer {
    private boolean isGearPowered;

    protected BlockGear(int n, int n2) {
        super(n, n2, Material.circuits);
        BlockGear.isBlockContainer[n] = true;
    }

    @Override
    public final AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int n, int n2, int n3) {
        return null;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.func_271_h(world, i, j, k);
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        if (world.isBlockNormalCube(i - 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            return true;
        }
        return world.isBlockNormalCube(i, j, k + 1);
    }

    private boolean func_271_h(World world, int i, int j, int k) {
        if (!this.canPlace(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
            return false;
        }
        return true;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        world.func_654_a(i, j, k, this.getBlockEntity());
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
    }

    private void notifyGearNeighborsOfNeighborChange(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
    }

    @Override
    public final boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public final boolean isCollidable() {
        return true;
    }

    @Override
    public final int tickRate() {
        return 1;
    }

    @Override
    public int getRenderType() {
        return 14;
    }

    @Override
    public final int quantityDropped(Random random) {
        return 1;
    }

    @Override
    public final boolean canProvidePower() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (j != 0) {
            return 78;
        }
        return 62;
    }

    public void applyGearPower(World world, int i, int j, int k) {
        world.setBlockMetadata(i, j, k, 1);
    }

    public void removeGearPower(World world, int i, int j, int k) {
        world.setBlockMetadata(i, j, k, 0);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityGear();
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        int l = world.getBlockMetadata(i, j, k);
        if (l == 0) {
            return;
        }
        world.spawnParticle("smoke", (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, 0.0, 0.0, 0.0);
    }
}

