/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.gui.ChatAllowedCharacters;
import com.mojang.minecraft.gui.Gui;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.render.FontRenderer;

public class GuiTextField
extends Gui {
    private final FontRenderer fontRenderer;
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;
    private String text;
    private int maxStringLength;
    private int cursorCounter;
    public boolean isFocused = false;
    public boolean isEnabled = true;
    private GuiScreen parentGuiScreen;

    public GuiTextField(GuiScreen guiscreen, FontRenderer fontrenderer, int i, int j, int k, int l, String s) {
        this.parentGuiScreen = guiscreen;
        this.fontRenderer = fontrenderer;
        this.xPos = i;
        this.yPos = j;
        this.width = k;
        this.height = l;
        this.setText(s);
    }

    public void setText(String s) {
        this.text = s;
    }

    public String getText() {
        return this.text;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void textboxKeyTyped(char c, int i) {
        if (!this.isEnabled || !this.isFocused) {
            return;
        }
        if (c == '\t') {
            this.parentGuiScreen.selectNextField();
        }
        if (c == '\u0016') {
            int j;
            String s = GuiScreen.getClipboardString();
            if (s == null) {
                s = "";
            }
            if ((j = 32 - this.text.length()) > s.length()) {
                j = s.length();
            }
            if (j > 0) {
                this.text = String.valueOf(this.text) + s.substring(0, j);
            }
        }
        if (i == 14 && this.text.length() > 0) {
            this.text = this.text.substring(0, this.text.length() - 1);
        }
        if (ChatAllowedCharacters.allowedCharacters.indexOf(c) >= 0 && (this.text.length() < this.maxStringLength || this.maxStringLength == 0)) {
            this.text = String.valueOf(this.text) + c;
        }
    }

    public void mouseClicked(int i, int j, int k) {
        boolean flag = this.isEnabled && i >= this.xPos && i < this.xPos + this.width && j >= this.yPos && j < this.yPos + this.height;
        this.setFocused(flag);
    }

    public void setFocused(boolean flag) {
        if (flag && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = flag;
    }

    public void drawTextBox() {
        this.drawRect(this.xPos - 1, this.yPos - 1, this.xPos + this.width + 1, this.yPos + this.height + 1, -6250336);
        this.drawRect(this.xPos, this.yPos, this.xPos + this.width, this.yPos + this.height, -16777216);
        if (this.isEnabled) {
            boolean flag = this.isFocused && this.cursorCounter / 6 % 2 == 0;
            this.drawString(this.fontRenderer, this.text + (flag ? "_" : ""), this.xPos + 4, this.yPos + (this.height - 8) / 2, 0xE0E0E0);
        } else {
            this.drawString(this.fontRenderer, this.text, this.xPos + 4, this.yPos + (this.height - 8) / 2, 0x707070);
        }
    }

    public void setMaxStringLength(int i) {
        this.maxStringLength = i;
    }
}

