/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.tile.Block;

public class ItemTool
extends Item {
    private Block[] toolBreakList;
    public boolean isGold;
    private float efficiencyOnProperMaterial;
    private int damageVsEntity;
    protected int toolMaterial_Int;

    public ItemTool(int i, int j, int k, Block[] ablock) {
        super(i);
        this.isGold = i == 27 || i == 28 || i == 29 || i == 30;
        this.efficiencyOnProperMaterial = 4.0f;
        this.toolMaterial_Int = k;
        this.toolBreakList = ablock;
        this.maxStackSize = 1;
        this.maxDamage = 32 << k;
        if (k >= 3) {
            this.maxDamage *= 4;
        }
        this.maxDamage *= 2;
        this.efficiencyOnProperMaterial = (k + 1) * 2;
        this.damageVsEntity = j + k;
    }

    @Override
    public float getStrVsBlock(ItemStack itemstack, Block block) {
        int i = 0;
        while (i < this.toolBreakList.length) {
            if (this.toolBreakList[i] == block) {
                return this.efficiencyOnProperMaterial;
            }
            ++i;
        }
        return 1.0f;
    }

    @Override
    public void damageItemHit(ItemStack itemstack, EntityLiving entityliving) {
        itemstack.damageItem(2);
    }

    @Override
    public void damageItemMine(ItemStack itemstack, int i, int j, int k, int l) {
        itemstack.damageItem(1);
    }

    @Override
    public int getDamageVsEntity(Entity entity) {
        return this.damageVsEntity;
    }

    @Override
    public boolean func_194_a() {
        return true;
    }
}

