/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.IMobs;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntitySlime
extends EntityLiving
implements IMobs {
    public float field_768_a;
    public float field_767_b;
    private int slimeJumpDelay = 0;

    public EntitySlime(World world) {
        super(world);
        this.scoreYield = 25;
        int getSlimeSize = 1;
        this.texture = "/mob/slime.png";
        getSlimeSize = 1 << this.rand.nextInt(3);
        this.yOffset = 0.0f;
        this.slimeJumpDelay = this.rand.nextInt(20) + 10;
        this.setSlimeSize(getSlimeSize);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Byte(1));
    }

    public void setSlimeSize(int i) {
        this.dataWatcher.updateObject(16, new Byte((byte)i));
        this.setSize(0.6f * (float)i, 0.6f * (float)i);
        this.health = i * i;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public int getSlimeSize() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setInteger("Size", this.getSlimeSize() - 1);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSlimeSize(nbttagcompound.getInteger("Size") + 1);
    }

    @Override
    public void onUpdate() {
        this.field_767_b = this.field_768_a;
        boolean flag = this.onGround;
        super.onUpdate();
        if (this.onGround && !flag) {
            int i = 0;
            while (i < this.getSlimeSize() * 8) {
                float f = this.rand.nextFloat() * 3.141593f * 2.0f;
                float f1 = this.rand.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.sin(f) * (float)this.getSlimeSize() * 0.5f * f1;
                float f3 = MathHelper.cos(f) * (float)this.getSlimeSize() * 0.5f * f1;
                this.worldObj.spawnParticle("slime", this.posX + (double)f2, this.boundingBox.minY, this.posZ + (double)f3, 0.0, 0.0, 0.0);
                ++i;
            }
            if (this.getSlimeSize() > 2) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.func_413_f(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.field_768_a = -0.5f;
        }
        this.field_768_a *= 0.6f;
    }

    @Override
    protected void updateEntityActionState() {
        EntityPlayer entityplayer = this.worldObj.getPlayerEntityAtHeight(this, 16.0);
        if (entityplayer != null) {
            this.func_426_b(entityplayer, 10.0f);
        }
        if (this.onGround && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.rand.nextInt(20) + 10;
            if (entityplayer != null) {
                this.slimeJumpDelay /= 3;
            }
            this.isJumping = true;
            if (this.getSlimeSize() > 1) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.func_413_f(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_768_a = 1.0f;
            this.movingLeftRight = 1.0f - this.rand.nextFloat() * 2.0f;
            this.movingForwardBack = 1 * this.getSlimeSize();
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.movingForwardBack = 0.0f;
                this.movingLeftRight = 0.0f;
            }
        }
    }

    @Override
    public void setEntityDead() {
        if (!this.worldObj.multiplayerWorld && this.getSlimeSize() > 1 && this.health <= 0) {
            int i = 0;
            while (i < 4) {
                float f = ((float)(i % 2) - 0.5f) * (float)this.getSlimeSize() / 4.0f;
                float f1 = ((float)(i / 2) - 0.5f) * (float)this.getSlimeSize() / 4.0f;
                EntitySlime entityslime = new EntitySlime(this.worldObj);
                entityslime.setSlimeSize(this.getSlimeSize() / 2);
                entityslime.setLocationAndAngles(this.posX + (double)f, this.posY + 0.5, this.posZ + (double)f1, this.rand.nextFloat() * 360.0f, 0.0f);
                this.worldObj.entityJoinedWorld(entityslime);
                ++i;
            }
        }
        super.setEntityDead();
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer entityplayer) {
        if (this.getSlimeSize() > 1 && this.canEntityBeSeen(entityplayer) && (double)this.getDistanceToEntity(entityplayer) < 0.6 * (double)this.getSlimeSize() && entityplayer.attackEntityFrom(this, this.getSlimeSize())) {
            this.worldObj.playSoundAtEntity(this, "mob.slimeattack", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    protected String hurtSound() {
        return "mob.slime";
    }

    @Override
    protected String deathSound() {
        return "mob.slime";
    }

    @Override
    protected int deathDropItem() {
        if (this.getSlimeSize() == 1) {
            return Item.slimeBall.shiftedIndex;
        }
        return 0;
    }

    @Override
    public boolean func_433_a() {
        Chunk chunk = this.worldObj.getChunkFromBlockCoords(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY));
        return (this.getSlimeSize() == 1 || this.worldObj.difficulty > 0) && this.rand.nextInt(10) == 0 && chunk.func_997_a(987234911L).nextInt(10) == 0 && this.posY < 16.0;
    }

    @Override
    protected float func_413_f() {
        return 0.6f;
    }
}

