/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityCreature;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.IMobs;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntityMobs
extends EntityCreature
implements IMobs {
    protected int maxHealth = 2;
    public double currentSpeed;

    public EntityMobs(World world) {
        super(world);
        this.health = 20;
        this.currentSpeed = 0.5;
        this.isRunning = true;
    }

    @Override
    public void onLivingUpdate() {
        float f = this.getEntityBrightness(1.0f);
        if (f > 0.5f) {
            this.field_701_U += 2;
        }
        super.onLivingUpdate();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.multiplayerWorld && this.worldObj.difficulty == 0) {
            this.setEntityDead();
        }
    }

    @Override
    protected Entity findPlayerToAttack() {
        EntityPlayer entityplayer = this.worldObj.getPlayerEntityAtHeight(this, 16.0);
        if (entityplayer != null && this.canEntityBeSeen(entityplayer)) {
            return entityplayer;
        }
        return null;
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int i) {
        if (super.attackEntityFrom(entity, i)) {
            if (this.riddenByEntity == entity || this.entityBeingRidden == entity) {
                return true;
            }
            if (entity != this) {
                this.entityToAttack = entity;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void attackEntity(Entity entity, float f) {
        if ((double)f < 2.5 && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            entity.attackEntityFrom(this, this.maxHealth - (entity.chainArmor + entity.diamondArmor) / 2);
        }
    }

    @Override
    protected float getBlockPathWeight(int i, int j, int k) {
        return 0.5f - this.worldObj.getBrightness(i, j, k);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    @Override
    public boolean func_433_a() {
        int k;
        int j;
        int i = MathHelper.floor_double(this.posX);
        if (this.worldObj.getBlockLighting(EnumSkyBlock.Sky, i, j = MathHelper.floor_double(this.boundingBox.minY), k = MathHelper.floor_double(this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int l = this.worldObj.getBlockLightValue(i, j, k);
        return l <= this.rand.nextInt(8) && super.func_433_a();
    }

    @Override
    public double getRealMoveSpeed() {
        return this.currentSpeed;
    }
}

