/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityArrow;
import com.mojang.minecraft.entity.EntityBoat;
import com.mojang.minecraft.entity.EntityChicken;
import com.mojang.minecraft.entity.EntityCow;
import com.mojang.minecraft.entity.EntityCreeper;
import com.mojang.minecraft.entity.EntityFallingSand;
import com.mojang.minecraft.entity.EntityGiant;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityMinecart;
import com.mojang.minecraft.entity.EntityMobs;
import com.mojang.minecraft.entity.EntityPainting;
import com.mojang.minecraft.entity.EntityPig;
import com.mojang.minecraft.entity.EntitySheep;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.EntitySlime;
import com.mojang.minecraft.entity.EntitySnowball;
import com.mojang.minecraft.entity.EntitySpider;
import com.mojang.minecraft.entity.EntityTNTPrimed;
import com.mojang.minecraft.entity.EntityZombie;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import java.util.HashMap;
import java.util.Map;

public class EntityList {
    private static Map<String, Class<?>> stringClassHash = new HashMap();
    private static Map<Class<?>, String> field_1610_b = new HashMap();
    private static Map<Integer, Class<?>> field_1613_c = new HashMap();
    private static Map<Class<?>, Integer> field_1612_d = new HashMap();

    static {
        EntityList.func_1080_a(EntityArrow.class, "Arrow", 10);
        EntityList.func_1080_a(EntitySnowball.class, "Snowball", 11);
        EntityList.func_1080_a(EntityItem.class, "Item", 1);
        EntityList.func_1080_a(EntityPainting.class, "Painting", 9);
        EntityList.func_1080_a(EntityLiving.class, "Mob", 48);
        EntityList.func_1080_a(EntityMobs.class, "Monster", 49);
        EntityList.func_1080_a(EntityCreeper.class, "Creeper", 50);
        EntityList.func_1080_a(EntitySkeleton.class, "Skeleton", 51);
        EntityList.func_1080_a(EntitySpider.class, "Spider", 52);
        EntityList.func_1080_a(EntityGiant.class, "Giant", 53);
        EntityList.func_1080_a(EntityZombie.class, "Zombie", 54);
        EntityList.func_1080_a(EntitySlime.class, "Slime", 55);
        EntityList.func_1080_a(EntityPig.class, "Pig", 90);
        EntityList.func_1080_a(EntitySheep.class, "Sheep", 91);
        EntityList.func_1080_a(EntityCow.class, "Cow", 92);
        EntityList.func_1080_a(EntityChicken.class, "Chicken", 93);
        EntityList.func_1080_a(EntityTNTPrimed.class, "PrimedTnt", 20);
        EntityList.func_1080_a(EntityFallingSand.class, "FallingSand", 21);
        EntityList.func_1080_a(EntityMinecart.class, "Minecart", 40);
        EntityList.func_1080_a(EntityBoat.class, "Boat", 41);
    }

    private static void func_1080_a(Class<?> class1, String s, int i) {
        stringClassHash.put(s, class1);
        field_1610_b.put(class1, s);
        field_1613_c.put(i, class1);
        field_1612_d.put(class1, i);
    }

    public static Entity createEntityByIdFromName(String s, World world) {
        Entity entity = null;
        try {
            Class<?> class1 = stringClassHash.get(s);
            if (class1 != null) {
                entity = (Entity)class1.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public static Entity func_1081_a(NBTTagCompound nbttagcompound, World world) {
        Entity entity = null;
        try {
            Class<?> class1 = stringClassHash.get(nbttagcompound.func_755_i("id"));
            if (class1 != null) {
                entity = (Entity)class1.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity != null) {
            entity.readFromNBT(nbttagcompound);
        } else {
            System.out.println("Skipping Entity with id " + nbttagcompound.func_755_i("id"));
        }
        return entity;
    }

    public static Entity createEntity(int i, World world) {
        Entity entity = null;
        try {
            Class<?> class1 = field_1613_c.get(i);
            if (class1 != null) {
                entity = (Entity)class1.getConstructor(World.class).newInstance(world);
                entity.entityId = i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            System.out.println("Skipping Entity with id " + i);
        }
        return entity;
    }

    public static int getEntityID(Entity entity) {
        return field_1612_d.get(entity.getClass());
    }

    public static String getEntityString(Entity entity) {
        return field_1610_b.get(entity.getClass());
    }
}

