/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityFX;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.render.Tessellator;
import java.util.Random;

public class EntityLavaFX
extends EntityFX {
    private float field_674_a;

    public EntityLavaFX(World world, double d, double d1, double d2) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.motionX *= (double)0.8f;
        this.motionY *= (double)0.8f;
        this.motionZ *= (double)0.8f;
        this.motionY = this.rand.nextFloat() * 0.4f + 0.05f;
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.particleScale *= this.rand.nextFloat() * 2.0f + 0.2f;
        this.field_674_a = this.particleScale;
        this.particleMaxAge = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.noClip = false;
        this.particleTextureIndex = 49;
        Random random = new Random();
        world.playSoundEffect((float)d + 0.5f, (float)d1 + 0.5f, (float)d2 + 0.5f, "liquid.lavapop", random.nextFloat() * 0.25f + 0.75f, random.nextFloat() * 1.0f + 0.5f);
    }

    @Override
    public float getEntityBrightness(float f) {
        return 1.0f;
    }

    @Override
    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        float f6 = ((float)this.particleAge + f) / (float)this.particleMaxAge;
        this.particleScale = this.field_674_a * (1.0f - f6 * f6);
        super.renderParticle(tessellator, f, f1, f2, f3, f4, f5);
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setEntityDead();
        }
        float f = (float)this.particleAge / (float)this.particleMaxAge;
        if (this.rand.nextFloat() > f) {
            this.worldObj.spawnParticle("smoke", this.posX, this.posY, this.posZ, this.motionX, this.motionY, this.motionZ);
        }
        this.motionY -= 0.03;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.999f;
        this.motionY *= (double)0.999f;
        this.motionZ *= (double)0.999f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
    }
}

