/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayerSP;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.networknew.NetClientHandler;
import com.mojang.minecraft.networknew.packet.Packet101CloseWindow;
import com.mojang.minecraft.networknew.packet.Packet10Flying;
import com.mojang.minecraft.networknew.packet.Packet11PlayerPosition;
import com.mojang.minecraft.networknew.packet.Packet12PlayerLook;
import com.mojang.minecraft.networknew.packet.Packet13PlayerLookMove;
import com.mojang.minecraft.networknew.packet.Packet14BlockDig;
import com.mojang.minecraft.networknew.packet.Packet18Animation;
import com.mojang.minecraft.networknew.packet.Packet19EntityAction;
import com.mojang.minecraft.networknew.packet.Packet3Chat;
import com.mojang.minecraft.networknew.packet.Packet9Respawn;
import com.mojang.minecraft.player.inventory.InventoryPlayer;
import com.mojang.minecraft.util.MathHelper;
import com.mojang.minecraft.util.Session;

public class EntityClientPlayerMP
extends EntityPlayerSP {
    public NetClientHandler sendQueue;
    private int field_9380_bx = 0;
    private boolean field_21093_bH;
    private double oldPosX;
    private double field_9378_bz;
    private double oldPosY;
    private double oldPosZ;
    private float oldRotationYaw;
    private float oldRotationPitch;
    private InventoryPlayer field_789_bo = new InventoryPlayer(null);
    private boolean field_9382_bF;
    private boolean wasSneaking;
    private boolean wasRunning;
    private int field_12242_bI;

    public EntityClientPlayerMP(Minecraft minecraft, World world, Session session, NetClientHandler netclienthandler) {
        super(minecraft, world, session);
        this.sendQueue = netclienthandler;
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int i) {
        return false;
    }

    @Override
    public void heal(int i) {
    }

    @Override
    public void onUpdate() {
        if (!this.worldObj.blockExists(MathHelper.floor_double(this.posX), 64, MathHelper.floor_double(this.posZ))) {
            return;
        }
        super.onUpdate();
        this.func_464_J();
    }

    public void func_464_J() {
        boolean flag2;
        boolean flagr;
        boolean flag;
        if (this.field_9380_bx++ == 20) {
            this.sendInventoryChanged();
            this.field_9380_bx = 0;
        }
        if ((flag = this.getIsSneaking()) != this.wasSneaking) {
            if (flag) {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 1));
            } else {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 2));
            }
            this.wasSneaking = flag;
        }
        if ((flagr = this.isRunning()) != this.wasRunning) {
            if (flagr) {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 3));
            } else {
                this.sendQueue.addToSendQueue(new Packet19EntityAction(this, 4));
            }
            this.wasRunning = flagr;
        }
        double d = this.posX - this.oldPosX;
        double d1 = this.boundingBox.minY - this.field_9378_bz;
        double d2 = this.posY - this.oldPosY;
        double d3 = this.posZ - this.oldPosZ;
        double d4 = this.rotationYaw - this.oldRotationYaw;
        double d5 = this.rotationPitch - this.oldRotationPitch;
        boolean flag1 = d1 != 0.0 || d2 != 0.0 || d != 0.0 || d3 != 0.0;
        boolean bl = flag2 = d4 != 0.0 || d5 != 0.0;
        if (this.entityBeingRidden != null) {
            if (flag2) {
                this.sendQueue.addToSendQueue(new Packet11PlayerPosition(this.motionX, -999.0, -999.0, this.motionZ, this.onGround));
            } else {
                this.sendQueue.addToSendQueue(new Packet13PlayerLookMove(this.motionX, -999.0, -999.0, this.motionZ, this.rotationYaw, this.rotationPitch, this.onGround));
            }
            flag1 = false;
        } else if (flag1 && flag2) {
            this.sendQueue.addToSendQueue(new Packet13PlayerLookMove(this.posX, this.boundingBox.minY, this.posY, this.posZ, this.rotationYaw, this.rotationPitch, this.onGround));
            this.field_12242_bI = 0;
        } else if (flag1) {
            this.sendQueue.addToSendQueue(new Packet11PlayerPosition(this.posX, this.boundingBox.minY, this.posY, this.posZ, this.onGround));
            this.field_12242_bI = 0;
        } else if (flag2) {
            this.sendQueue.addToSendQueue(new Packet12PlayerLook(this.rotationYaw, this.rotationPitch, this.onGround));
            this.field_12242_bI = 0;
        } else {
            this.sendQueue.addToSendQueue(new Packet10Flying(this.onGround));
            this.field_12242_bI = this.field_9382_bF != this.onGround || this.field_12242_bI > 200 ? 0 : ++this.field_12242_bI;
        }
        this.field_9382_bF = this.onGround;
        if (flag1) {
            this.oldPosX = this.posX;
            this.field_9378_bz = this.boundingBox.minY;
            this.oldPosY = this.posY;
            this.oldPosZ = this.posZ;
        }
        if (flag2) {
            this.oldRotationYaw = this.rotationYaw;
            this.oldRotationPitch = this.rotationPitch;
        }
    }

    public void dropCurrentItem() {
        this.sendQueue.addToSendQueue(new Packet14BlockDig(4, 0, 0, 0, 0));
    }

    private void sendInventoryChanged() {
    }

    protected void joinEntityItemWithWorld(EntityItem entityitem) {
    }

    @Override
    public void sendChatMessage(String s) {
        this.sendQueue.addToSendQueue(new Packet3Chat(s));
    }

    @Override
    public void swingItem() {
        super.swingItem();
        this.sendQueue.addToSendQueue(new Packet18Animation(this, 1));
    }

    @Override
    public void respawnPlayer() {
        this.sendInventoryChanged();
        this.sendQueue.addToSendQueue(new Packet9Respawn(-1));
    }

    @Override
    protected void damageEntity(int i) {
        this.health -= i;
    }

    @Override
    public void closeScreen() {
        this.sendQueue.addToSendQueue(new Packet101CloseWindow(this.craftingInventory.windowId));
        this.inventory.setItemStack(null);
        super.closeScreen();
    }

    @Override
    public void setHealth(int i) {
        if (this.field_21093_bH) {
            super.setHealth(i);
        } else {
            this.health = i;
            this.field_21093_bH = true;
        }
    }
}

