/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.networknew;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.gui.GuiConnectFailed;
import com.mojang.minecraft.gui.GuiConnecting;
import com.mojang.minecraft.networknew.NetClientHandler;
import com.mojang.minecraft.networknew.packet.Packet2Handshake;
import java.net.ConnectException;
import java.net.UnknownHostException;

class ThreadConnectToServer
extends Thread {
    final Minecraft mc;
    final String hostName;
    final int port;
    final GuiConnecting connectingGui;

    public ThreadConnectToServer(GuiConnecting guiconnecting, Minecraft minecraft, String s, int i) {
        this.connectingGui = guiconnecting;
        this.mc = minecraft;
        this.hostName = s;
        this.port = i;
    }

    public void run() {
        try {
            GuiConnecting.setNetClientHandler(this.connectingGui, new NetClientHandler(this.mc, this.hostName, this.port));
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            GuiConnecting.func_583_b(this.connectingGui).addToSendQueue(new Packet2Handshake(this.mc.session.username));
        }
        catch (UnknownHostException unknownhostexception) {
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            this.mc.setCurrentScreen(new GuiConnectFailed("Failed to connect to the server", "Unknown host '" + this.hostName + "'"));
        }
        catch (ConnectException connectexception) {
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            this.mc.setCurrentScreen(new GuiConnectFailed("Failed to connect to the server", connectexception.getMessage()));
        }
        catch (Exception exception) {
            if (GuiConnecting.isCancelled(this.connectingGui)) {
                return;
            }
            exception.printStackTrace();
            this.mc.setCurrentScreen(new GuiConnectFailed("Failed to connect to the server", exception.toString()));
        }
    }
}

