/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockLightBulb
extends Block {
    protected BlockLightBulb(int i) {
        super(i, Material.glass);
        this.blockIndexInTexture = i + 5;
    }

    public void onBlockAdded(World world, int a, int b, int c) {
        super.onBlockAdded(world, a, b, c);
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean power = this.isReceivingRedstonePower(world, i, j, k, l);
        if (power) {
            world.setBlock(i, j, k, 98);
        } else {
            world.setBlock(i, j, k, 97);
        }
    }

    public int idDropped(int i, Random random) {
        return Block.lightBulb.blockID;
    }

    public static boolean isPowered(int i) {
        return (i & 8) != 0;
    }

    public void updateTick(World world, int a, int b, int c, Random random) {
        super.updateTick(world, a, b, c, random);
    }

    private boolean isReceivingRedstonePower(World world, int i, int j, int k, int l) {
        if (l != 0 && world.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (l != 1 && world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (l != 2 && world.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (l != 3 && world.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (l != 5 && world.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5)) {
            return true;
        }
        if (l != 4 && world.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j, k, 0)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 2, k, 1)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k - 1, 2)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k + 1, 3)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i - 1, j + 1, k, 4)) {
            return true;
        }
        return world.isBlockIndirectlyProvidingPowerTo(i + 1, j + 1, k, 5);
    }

    public void dropBlockAsItemWithChance(World world, int a, int b, int c, int bid) {
        super.dropBlockAsItemWithChance(world, a, b, c, bid);
    }
}

