/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockBreakable;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockIce
extends BlockBreakable {
    public BlockIce(int i, int j) {
        super(i, j, Material.ice, false);
        this.field_355_bo = 0.98f;
        this.setTickOnLoad(true);
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return super.shouldSideBeRendered(iblockaccess, i, j, k, 1 - l);
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        Material material = world.getMaterialXYZ(i, j - 1, k);
        if (material.blocksMovement() || material.getIsGroundCover()) {
            world.setBlockWithNotify(i, j, k, Block.waterMoving.blockID);
        }
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.getBlockLighting(EnumSkyBlock.Block, i, j, k) > 11 - Block.lightOpacity[this.blockID]) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, Block.waterStill.blockID);
        }
    }
}

