/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityList;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.generate.IChunkLoader;
import com.mojang.minecraft.level.generate.noise.NibbleArray;
import com.mojang.minecraft.level.region.RegionFileCache;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.util.CompressedStreamTools;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ChunkLoader
implements IChunkLoader {
    private File basePath;

    public ChunkLoader(File file, boolean flag) {
        this.basePath = file;
    }

    private File getChunkFile(int i, int j) {
        String s = "c." + Integer.toString(i, 36) + "." + Integer.toString(j, 36) + ".dat";
        String s1 = Integer.toString(i & 0x3F, 36);
        String s2 = Integer.toString(j & 0x3F, 36);
        File file = new File(this.basePath, s1);
        file = new File(file, s2);
        file = new File(file, s);
        return file;
    }

    public Chunk func_813_a(World world, int x, int z) throws IOException {
        NBTTagCompound nbt;
        DataInputStream regionChunkInputStream = RegionFileCache.getChunkDataInputStream(this.basePath, x, z);
        File chunkFile = this.getChunkFile(x, z);
        if (regionChunkInputStream != null) {
            nbt = CompressedStreamTools.func_1138_a(regionChunkInputStream);
        } else if (chunkFile.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(chunkFile);
                nbt = CompressedStreamTools.func_1138_a(inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        } else {
            return null;
        }
        if (!nbt.func_751_b("Level")) {
            System.out.println("Chunk file at " + x + "," + z + " is missing level data, skipping");
            return null;
        }
        if (!nbt.func_743_k("Level").func_751_b("Blocks")) {
            System.out.println("Chunk file at " + x + "," + z + " is missing block data, skipping");
            return null;
        }
        Chunk var7 = ChunkLoader.func_816_a(world, nbt.func_743_k("Level"));
        if (!var7.isAtLocation(x, z)) {
            System.out.println("Chunk file at " + x + "," + z + " is in the wrong location; relocating. (Expected " + x + ", " + z + ", got " + var7.xPosition + ", " + var7.zPosition + ")");
            nbt.setInteger("xPos", x);
            nbt.setInteger("zPos", z);
            var7 = ChunkLoader.func_816_a(world, nbt.func_743_k("Level"));
        }
        try {
            if (regionChunkInputStream != null) {
                regionChunkInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return var7;
    }

    public void func_812_a(World world, Chunk chunk) throws IOException {
        world.func_663_l();
        DataOutputStream output = RegionFileCache.getChunkDataOutputStream(this.basePath, chunk.xPosition, chunk.zPosition);
        NBTTagCompound var6 = new NBTTagCompound();
        NBTTagCompound var7 = new NBTTagCompound();
        var6.func_762_a("Level", var7);
        this.func_818_a(chunk, world, var7);
        CompressedStreamTools.func_1143_a(var6, output);
        try {
            output.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        world.sizeOnDisk += (long)RegionFileCache.getSizeDelta(this.basePath, chunk.xPosition, chunk.zPosition);
    }

    public void func_818_a(Chunk chunk, World world, NBTTagCompound nbttagcompound) {
        world.func_663_l();
        nbttagcompound.setInteger("xPos", chunk.xPosition);
        nbttagcompound.setInteger("zPos", chunk.zPosition);
        nbttagcompound.setLong("LastUpdate", world.worldTime);
        nbttagcompound.func_747_a("Blocks", chunk.blocks);
        nbttagcompound.func_747_a("Data", chunk.data.data);
        nbttagcompound.func_747_a("SkyLight", chunk.skylightMap.data);
        nbttagcompound.func_747_a("BlockLight", chunk.blocklightMap.data);
        nbttagcompound.func_747_a("HeightMap", chunk.heightMap);
        nbttagcompound.setBool("TerrainPopulated", chunk.isTerrainPopulated);
        chunk.hasEntities = false;
        NBTTagList nbttaglist = new NBTTagList();
        int i = 0;
        while (i < chunk.entities.length) {
            for (Entity entity : chunk.entities[i]) {
                chunk.hasEntities = true;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                if (!entity.addEntityID(nbttagcompound1)) continue;
                nbttaglist.setTag(nbttagcompound1);
            }
            ++i;
        }
        nbttagcompound.func_762_a("Entities", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (TileEntity tileentity : chunk.chunkTileEntityMap.values()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            tileentity.func_481_b(nbttagcompound2);
            nbttaglist1.setTag(nbttagcompound2);
        }
        nbttagcompound.func_762_a("TileEntities", nbttaglist1);
    }

    public static Chunk func_816_a(World world, NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist1;
        NBTTagList nbttaglist;
        int i = nbttagcompound.getInteger("xPos");
        int j = nbttagcompound.getInteger("zPos");
        Chunk chunk = new Chunk(world, i, j);
        chunk.blocks = nbttagcompound.func_759_j("Blocks");
        chunk.data = new NibbleArray(nbttagcompound.func_759_j("Data"));
        chunk.skylightMap = new NibbleArray(nbttagcompound.func_759_j("SkyLight"));
        chunk.blocklightMap = new NibbleArray(nbttagcompound.func_759_j("BlockLight"));
        chunk.heightMap = nbttagcompound.func_759_j("HeightMap");
        chunk.isTerrainPopulated = nbttagcompound.tag("TerrainPopulated");
        if (!chunk.data.func_769_a()) {
            chunk.data = new NibbleArray(chunk.blocks.length);
        }
        if (chunk.heightMap == null || !chunk.skylightMap.func_769_a()) {
            chunk.heightMap = new byte[256];
            chunk.skylightMap = new NibbleArray(chunk.blocks.length);
            chunk.func_1024_c();
        }
        if (!chunk.blocklightMap.func_769_a()) {
            chunk.blocklightMap = new NibbleArray(chunk.blocks.length);
            chunk.func_1014_a();
        }
        if ((nbttaglist = nbttagcompound.func_753_l("Entities")) != null) {
            int k = 0;
            while (k < nbttaglist.func_740_c()) {
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_741_a(k);
                Entity entity = EntityList.func_1081_a(nbttagcompound1, world);
                chunk.hasEntities = true;
                if (entity != null) {
                    chunk.addEntity(entity);
                }
                ++k;
            }
        }
        if ((nbttaglist1 = nbttagcompound.func_753_l("TileEntities")) != null) {
            int l = 0;
            while (l < nbttaglist1.func_740_c()) {
                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist1.func_741_a(l);
                TileEntity tileentity = TileEntity.func_477_c(nbttagcompound2);
                if (tileentity != null) {
                    chunk.addTileEntity(tileentity);
                }
                ++l;
            }
        }
        return chunk;
    }

    public void func_814_a() {
    }

    public void func_811_b() {
    }

    public void func_815_b(World world, Chunk chunk) {
    }
}

