/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.tile;

import com.mojang.minecraft.entity.tile.TileEntityGear;
import com.mojang.minecraft.level.World;
import java.util.ArrayList;

public class GearGroup {
    private ArrayList<TileEntityGear> gearCache;
    private World mcWorld;
    private int limit;
    private boolean isPowered;

    public GearGroup(World world) {
        this.mcWorld = world;
        this.gearCache = new ArrayList();
        this.limit = 0;
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    public void addToLimit(int lim) {
        this.limit += lim;
    }

    public void subFromLimit(int lim) {
        this.limit -= lim;
    }

    public void addToGearGroup(TileEntityGear gearEntity) {
        System.out.println("Adding " + gearEntity);
        this.gearCache.add(gearEntity);
    }

    public void removeFromGearGroup(TileEntityGear gearEntity) {
        System.out.println("Removing " + gearEntity);
        this.gearCache.remove(gearEntity);
    }

    public void mergeGroup(GearGroup newgroup) {
        int i = 0;
        while (i < newgroup.getGearGroupSize()) {
            this.addToGearGroup(newgroup.getGear(0));
            newgroup.removeFromGearGroup(newgroup.getGear(0));
            ++i;
        }
    }

    public TileEntityGear getGear(int index) {
        return this.gearCache.get(index);
    }

    public boolean hasGear(TileEntityGear gearEntity) {
        return this.gearCache.contains(gearEntity);
    }

    public int getGearGroupSize() {
        return this.gearCache.size();
    }

    public boolean isBelowThreshold(int threshold) {
        return this.gearCache.size() < threshold;
    }

    public boolean powerGearCache() {
        System.out.println("Being powered!");
        if (this.gearCache.size() < this.limit) {
            int i = 0;
            while (i < this.gearCache.size()) {
                this.gearCache.get(i).setGearActive(this.mcWorld, 1);
                ++i;
            }
            this.isPowered = true;
            return true;
        }
        int i = 0;
        while (i < this.gearCache.size()) {
            this.gearCache.get(i).setGearActive(this.mcWorld, 0);
            ++i;
        }
        this.isPowered = false;
        return false;
    }

    public boolean unPowerGearCache() {
        int i = 0;
        while (i < this.gearCache.size() - 1) {
            this.gearCache.get(i).setGearActive(this.mcWorld, 0);
            ++i;
        }
        this.isPowered = false;
        return true;
    }

    public boolean checkPowered() {
        return this.isPowered;
    }
}

