/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.Random;

public class BlockDoor
extends Block {
    protected BlockDoor(int i, Material material) {
        super(i, material);
        this.blockIndexInTexture = 97;
        if (material == Material.iron) {
            ++this.blockIndexInTexture;
        }
        float f = 0.5f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 0 || i == 1) {
            return this.blockIndexInTexture;
        }
        int k = this.func_312_c(j);
        if ((k == 0 || k == 2) ^ i <= 3) {
            return this.blockIndexInTexture;
        }
        int l = k / 2 + (i & 1 ^ k);
        int i1 = this.blockIndexInTexture - (j & 8) * 2;
        if (((l += (j & 4) / 4) & 1) != 0) {
            i1 = -i1;
        }
        return i1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return 7;
    }

    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getSelectedCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        this.func_313_b(this.func_312_c(iblockaccess.getBlockMetadata(i, j, k)));
    }

    public void func_313_b(int i) {
        float f = 0.1875f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        if (i == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (i == 1) {
            this.setBlockBounds(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (i == 2) {
            this.setBlockBounds(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (i == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
    }

    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        this.blockActivated(world, i, j, k, entityplayer);
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (this.blockMaterial == Material.iron) {
            return true;
        }
        int l = world.getBlockMetadata(i, j, k);
        if ((l & 8) != 0) {
            if (world.getBlockId(i, j - 1, k) == this.blockID) {
                this.blockActivated(world, i, j - 1, k, entityplayer);
            }
            return true;
        }
        if (world.getBlockId(i, j + 1, k) == this.blockID) {
            world.setBlockMetadataWithNotify(i, j + 1, k, (l ^ 4) + 8);
        }
        world.setBlockMetadataWithNotify(i, j, k, l ^ 4);
        world.markBlocksDirty(i, j - 1, k, i, j, k);
        if (Math.random() < 0.5) {
            world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.door_open", 1.0f, world.rand.nextFloat() * 0.1f + 0.9f);
        } else {
            world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.door_close", 1.0f, world.rand.nextFloat() * 0.1f + 0.9f);
        }
        return true;
    }

    public void func_311_a(World world, int i, int j, int k, boolean flag) {
        boolean flag1;
        int l = world.getBlockMetadata(i, j, k);
        if ((l & 8) != 0) {
            if (world.getBlockId(i, j - 1, k) == this.blockID) {
                this.func_311_a(world, i, j - 1, k, flag);
            }
            return;
        }
        boolean bl = flag1 = (world.getBlockMetadata(i, j, k) & 4) > 0;
        if (flag1 == flag) {
            return;
        }
        if (world.getBlockId(i, j + 1, k) == this.blockID) {
            world.setBlockMetadataWithNotify(i, j + 1, k, (l ^ 4) + 8);
        }
        world.setBlockMetadataWithNotify(i, j, k, l ^ 4);
        world.markBlocksDirty(i, j - 1, k, i, j, k);
        if (Math.random() < 0.5) {
            world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.door_open", 1.0f, world.rand.nextFloat() * 0.1f + 0.9f);
        } else {
            world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.door_close", 1.0f, world.rand.nextFloat() * 0.1f + 0.9f);
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        if ((i1 & 8) != 0) {
            if (world.getBlockId(i, j - 1, k) != this.blockID) {
                world.setBlockWithNotify(i, j, k, 0);
            }
            if (l > 0 && Block.allBlocks[l].canProvidePower()) {
                this.onNeighborBlockChange(world, i, j - 1, k, l);
            }
        } else {
            boolean flag = false;
            if (world.getBlockId(i, j + 1, k) != this.blockID) {
                world.setBlockWithNotify(i, j, k, 0);
                flag = true;
            }
            if (!world.isBlockNormalCube(i, j - 1, k)) {
                world.setBlockWithNotify(i, j, k, 0);
                flag = true;
                if (world.getBlockId(i, j + 1, k) == this.blockID) {
                    world.setBlockWithNotify(i, j + 1, k, 0);
                }
            }
            if (flag) {
                if (!world.multiplayerWorld) {
                    this.dropBlockAsItem(world, i, j, k, i1);
                }
            } else if (l > 0 && Block.allBlocks[l].canProvidePower()) {
                boolean flag1 = world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k);
                this.func_311_a(world, i, j, k, flag1);
            }
        }
    }

    public int idDropped(int i, Random random) {
        if ((i & 8) != 0) {
            return 0;
        }
        if (this.blockMaterial == Material.iron) {
            return Item.doorSteel.shiftedIndex;
        }
        return Item.doorWood.shiftedIndex;
    }

    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
    }

    public int func_312_c(int i) {
        if ((i & 4) == 0) {
            return i - 1 & 3;
        }
        return i & 3;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        if (j >= 127) {
            return false;
        }
        return world.isBlockNormalCube(i, j - 1, k) && super.canPlace(world, i, j, k) && super.canPlace(world, i, j + 1, k);
    }
}

