/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityDiggingFX;
import com.mojang.minecraft.entity.EntityFX;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.render.RenderEngine;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public class EffectRenderer {
    protected World field_1729_a;
    private List<Object>[] field_1728_b = new List[4];
    private RenderEngine field_1731_c;
    private Random field_1730_d = new Random();

    public EffectRenderer(World world, RenderEngine renderengine) {
        if (world != null) {
            this.field_1729_a = world;
        }
        this.field_1731_c = renderengine;
        int i = 0;
        while (i < 4) {
            this.field_1728_b[i] = new ArrayList<Object>();
            ++i;
        }
    }

    public void addEffect(EntityFX entityfx) {
        int i = entityfx.func_404_c();
        this.field_1728_b[i].add(entityfx);
    }

    public void func_1193_a() {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < this.field_1728_b[i].size()) {
                EntityFX entityfx = (EntityFX)this.field_1728_b[i].get(j);
                entityfx.onUpdate();
                if (entityfx.hasDied) {
                    this.field_1728_b[i].remove(j--);
                }
                ++j;
            }
            ++i;
        }
    }

    public void func_1189_a(Entity entity, float f) {
        float f1 = MathHelper.cos(entity.rotationYaw * 3.141593f / 180.0f);
        float f2 = MathHelper.sin(entity.rotationYaw * 3.141593f / 180.0f);
        float f3 = -f2 * MathHelper.sin(entity.rotationPitch * 3.141593f / 180.0f);
        float f4 = f1 * MathHelper.sin(entity.rotationPitch * 3.141593f / 180.0f);
        float f5 = MathHelper.cos(entity.rotationPitch * 3.141593f / 180.0f);
        EntityFX.field_660_l = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)f;
        EntityFX.field_659_m = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)f;
        EntityFX.field_658_n = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)f;
        int i = 0;
        while (i < 3) {
            if (this.field_1728_b[i].size() != 0) {
                int j = 0;
                if (i == 0) {
                    j = this.field_1731_c.bindTexture("/particles.png");
                }
                if (i == 1) {
                    j = this.field_1731_c.bindTexture("/terrain.png");
                }
                if (i == 2) {
                    j = this.field_1731_c.bindTexture("/gui/items.png");
                }
                GL11.glBindTexture((int)3553, (int)j);
                Tessellator tessellator = Tessellator.field_1512_a;
                tessellator.func_977_b();
                int k = 0;
                while (k < this.field_1728_b[i].size()) {
                    EntityFX entityfx = (EntityFX)this.field_1728_b[i].get(k);
                    entityfx.func_406_a(tessellator, f, f1, f5, f2, f3, f4);
                    ++k;
                }
                tessellator.func_982_a();
            }
            ++i;
        }
    }

    public void func_1187_b(Entity entity, float f) {
        int byte0 = 3;
        if (this.field_1728_b[byte0].size() == 0) {
            return;
        }
        Tessellator tessellator = Tessellator.field_1512_a;
        int i = 0;
        while (i < this.field_1728_b[byte0].size()) {
            EntityFX entityfx = (EntityFX)this.field_1728_b[byte0].get(i);
            entityfx.func_406_a(tessellator, f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            ++i;
        }
    }

    public void func_1188_a(World world) {
        this.field_1729_a = world;
        int i = 0;
        while (i < 4) {
            this.field_1728_b[i].clear();
            ++i;
        }
    }

    public void func_1186_a(int i, int j, int k) {
        int l = this.field_1729_a.getBlockId(i, j, k);
        if (l == 0) {
            return;
        }
        Block block = Block.allBlocks[l];
        int i1 = 4;
        int j1 = 0;
        while (j1 < i1) {
            int k1 = 0;
            while (k1 < i1) {
                int l1 = 0;
                while (l1 < i1) {
                    double d = (double)i + ((double)j1 + 0.5) / (double)i1;
                    double d1 = (double)j + ((double)k1 + 0.5) / (double)i1;
                    double d2 = (double)k + ((double)l1 + 0.5) / (double)i1;
                    this.addEffect(new EntityDiggingFX(this.field_1729_a, d, d1, d2, d - (double)i - 0.5, d1 - (double)j - 0.5, d2 - (double)k - 0.5, block));
                    ++l1;
                }
                ++k1;
            }
            ++j1;
        }
    }

    public void func_1191_a(int i, int j, int k, int l) {
        int i1 = this.field_1729_a.getBlockId(i, j, k);
        if (i1 == 0) {
            return;
        }
        Block block = Block.allBlocks[i1];
        float f = 0.1f;
        double d = (double)i + this.field_1730_d.nextDouble() * (block.maxX - block.minX - (double)(f * 2.0f)) + (double)f + block.minX;
        double d1 = (double)j + this.field_1730_d.nextDouble() * (block.maxY - block.minY - (double)(f * 2.0f)) + (double)f + block.minY;
        double d2 = (double)k + this.field_1730_d.nextDouble() * (block.maxZ - block.minZ - (double)(f * 2.0f)) + (double)f + block.minZ;
        if (l == 0) {
            d1 = (double)j + block.minY - (double)f;
        }
        if (l == 1) {
            d1 = (double)j + block.maxY + (double)f;
        }
        if (l == 2) {
            d2 = (double)k + block.minZ - (double)f;
        }
        if (l == 3) {
            d2 = (double)k + block.maxZ + (double)f;
        }
        if (l == 4) {
            d = (double)i + block.minX - (double)f;
        }
        if (l == 5) {
            d = (double)i + block.maxX + (double)f;
        }
        this.addEffect(new EntityDiggingFX(this.field_1729_a, d, d1, d2, 0.0, 0.0, 0.0, block).func_407_b(0.2f).func_405_d(0.6f));
    }

    public String func_1190_b() {
        return "" + (this.field_1728_b[0].size() + this.field_1728_b[1].size() + this.field_1728_b[2].size());
    }
}

