/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.inventory;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.ItemArmor;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;

public class InventoryPlayer
implements IInventory {
    public ItemStack[] mainInventory = new ItemStack[37];
    public ItemStack[] armorInventory = new ItemStack[4];
    public ItemStack[] craftingInventory = new ItemStack[4];
    public int currentItem = 0;
    private EntityPlayer player;
    public ItemStack itemStack;
    public boolean inventoryChanged = false;

    public InventoryPlayer(EntityPlayer entityplayer) {
        this.player = entityplayer;
    }

    public ItemStack getCurrentItem() {
        return this.mainInventory[this.currentItem];
    }

    private int findItem(int i) {
        int j = 0;
        while (j < this.mainInventory.length) {
            if (this.mainInventory[j] != null && this.mainInventory[j].itemID == i) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private int func_497_g(int i) {
        int j = 0;
        while (j < this.mainInventory.length) {
            if (this.mainInventory[j] != null && this.mainInventory[j].itemID == i && this.mainInventory[j].stackSize < this.mainInventory[j].getMaxStackSize() && this.mainInventory[j].stackSize < this.getInventoryStackLimit()) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private int func_499_j() {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void replaceSlot(int i, boolean flag) {
        int j;
        if (flag && i > 0) {
            this.mainInventory[this.currentItem] = new ItemStack(i);
        }
        if ((j = this.findItem(i)) >= 0 && j < 36) {
            if (j >= 9) {
                ItemStack h = this.mainInventory[this.currentItem];
                this.mainInventory[this.currentItem] = this.mainInventory[j];
                this.mainInventory[j] = h;
            } else {
                this.currentItem = j;
            }
            return;
        }
    }

    public void func_498_a(int i) {
        if (i > 0) {
            i = 1;
        }
        if (i < 0) {
            i = -1;
        }
        this.currentItem -= i;
        while (this.currentItem < 0) {
            this.currentItem += 9;
        }
        while (this.currentItem >= 9) {
            this.currentItem -= 9;
        }
    }

    private int func_495_b(int i, int j) {
        int l;
        int k = this.func_497_g(i);
        if (k < 0) {
            k = this.func_499_j();
        }
        if (k < 0) {
            return j;
        }
        if (this.mainInventory[k] == null) {
            this.mainInventory[k] = new ItemStack(i, 0);
        }
        if ((l = j) > this.mainInventory[k].getMaxStackSize() - this.mainInventory[k].stackSize) {
            l = this.mainInventory[k].getMaxStackSize() - this.mainInventory[k].stackSize;
        }
        if (l > this.getInventoryStackLimit() - this.mainInventory[k].stackSize) {
            l = this.getInventoryStackLimit() - this.mainInventory[k].stackSize;
        }
        if (l == 0) {
            return j;
        }
        this.mainInventory[k].stackSize += l;
        this.mainInventory[k].animationsToGo = 5;
        return j -= l;
    }

    public void func_511_b() {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] != null && this.mainInventory[i].animationsToGo > 0) {
                --this.mainInventory[i].animationsToGo;
            }
            ++i;
        }
    }

    public boolean func_510_b(int i) {
        int j = this.findItem(i);
        if (j < 0) {
            return false;
        }
        if (--this.mainInventory[j].stackSize <= 0) {
            this.mainInventory[j] = null;
        }
        return true;
    }

    public boolean func_504_a(ItemStack itemstack) {
        int i;
        if (itemstack.itemDamage == 0) {
            itemstack.stackSize = this.func_495_b(itemstack.itemID, itemstack.stackSize);
            if (itemstack.stackSize == 0) {
                return true;
            }
        }
        if ((i = this.func_499_j()) >= 0) {
            this.mainInventory[i] = itemstack;
            this.mainInventory[i].animationsToGo = 5;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i >= this.mainInventory.length) {
            aitemstack = this.armorInventory;
            i -= this.mainInventory.length;
        }
        if (aitemstack[i] != null) {
            if (aitemstack[i].stackSize <= j) {
                ItemStack itemstack = aitemstack[i];
                aitemstack[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = aitemstack[i].splitStack(j);
            if (aitemstack[i].stackSize == 0) {
                aitemstack[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public int getSpongeCount() {
        int count = 0;
        if (this.armorInventory[0] != null && this.armorInventory[0].itemID == 374) {
            ++count;
        }
        if (this.armorInventory[1] != null && this.armorInventory[1].itemID == 373) {
            ++count;
        }
        if (this.armorInventory[2] != null && this.armorInventory[2].itemID == 372) {
            ++count;
        }
        if (this.armorInventory[3] != null && this.armorInventory[3].itemID == 371) {
            ++count;
        }
        return count;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i >= aitemstack.length) {
            i -= aitemstack.length;
            aitemstack = this.armorInventory;
        }
        if (i >= aitemstack.length) {
            i -= aitemstack.length;
            aitemstack = this.craftingInventory;
        }
        aitemstack[i] = itemstack;
    }

    public float func_508_a(Block block) {
        float f = 1.0f;
        if (this.mainInventory[this.currentItem] != null) {
            f *= this.mainInventory[this.currentItem].getStrVsBlock(block);
        }
        return f;
    }

    public NBTTagList func_493_a(NBTTagList nbttaglist) {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.setByte("Slot", (byte)i);
                this.mainInventory[i].writeToNBT(nbttagcompound);
                nbttaglist.func_742_a(nbttagcompound);
            }
            ++i;
        }
        int j = 0;
        while (j < this.armorInventory.length) {
            if (this.armorInventory[j] != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)(j + 100));
                this.armorInventory[j].writeToNBT(nbttagcompound1);
                nbttaglist.func_742_a(nbttagcompound1);
            }
            ++j;
        }
        int k = 0;
        while (k < this.craftingInventory.length) {
            if (this.craftingInventory[k] != null) {
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.setByte("Slot", (byte)(k + 80));
                this.craftingInventory[k].writeToNBT(nbttagcompound2);
                nbttaglist.func_742_a(nbttagcompound2);
            }
            ++k;
        }
        return nbttaglist;
    }

    public void func_513_b(NBTTagList nbttaglist) {
        this.mainInventory = new ItemStack[36];
        this.armorInventory = new ItemStack[4];
        this.craftingInventory = new ItemStack[4];
        int i = 0;
        while (i < nbttaglist.func_740_c()) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.func_741_a(i);
            int j = nbttagcompound.func_746_c("Slot") & 0xFF;
            if (j >= 0 && j < this.mainInventory.length) {
                this.mainInventory[j] = new ItemStack(nbttagcompound);
            }
            if (j >= 80 && j < this.craftingInventory.length + 80) {
                this.craftingInventory[j - 80] = new ItemStack(nbttagcompound);
            }
            if (j >= 100 && j < this.armorInventory.length + 100) {
                this.armorInventory[j - 100] = new ItemStack(nbttagcompound);
            }
            ++i;
        }
    }

    @Override
    public int getSizeInventory() {
        return this.mainInventory.length + 4;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i >= aitemstack.length) {
            i -= aitemstack.length;
            aitemstack = this.armorInventory;
        }
        if (i >= aitemstack.length) {
            i -= aitemstack.length;
            aitemstack = this.craftingInventory;
        }
        return aitemstack[i];
    }

    @Override
    public String getInvName() {
        return "Inventory";
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public int func_502_a(Entity entity) {
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.getDamageVsEntity(entity);
        }
        return 1;
    }

    public boolean blockBreakCheck(Block canBreakWithHands) {
        if (canBreakWithHands.blockMaterial != Material.rock && canBreakWithHands.blockMaterial != Material.iron && canBreakWithHands.blockMaterial != Material.builtSnow && canBreakWithHands.blockMaterial != Material.snow && canBreakWithHands.blockMaterial != Material.glass && canBreakWithHands.blockMaterial != Material.ice) {
            return true;
        }
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.canHarvestBlock(canBreakWithHands);
        }
        return false;
    }

    public boolean blockGoldTouchCheck(Block canBreakWithHands) {
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.isGold();
        }
        return false;
    }

    public ItemStack func_492_d(int i) {
        return this.armorInventory[i];
    }

    public int func_506_f() {
        int armorNewDmg = 0;
        int armorDmg = 0;
        int armorMaxDmg = 0;
        int l = 0;
        while (l < this.armorInventory.length) {
            if (this.armorInventory[l] != null && this.armorInventory[l].getItem() instanceof ItemArmor && this.armorInventory[l].itemID != 374 && this.armorInventory[l].itemID != 373 && this.armorInventory[l].itemID != 372 && this.armorInventory[l].itemID != 371) {
                int maxDmg = this.armorInventory[l].getMaxDmg();
                int currDmg = this.armorInventory[l].itemDamage;
                int newDmg = maxDmg - currDmg;
                armorDmg += newDmg;
                armorMaxDmg += maxDmg;
                int l1 = ((ItemArmor)this.armorInventory[l].getItem()).protectionLevel;
                armorNewDmg += l1;
            }
            ++l;
        }
        if (armorMaxDmg == 0) {
            return 0;
        }
        return (armorNewDmg - 1) * armorDmg / armorMaxDmg + 1;
    }

    public void func_507_e(int i) {
        int j = 0;
        while (j < this.armorInventory.length) {
            if (this.armorInventory[j] != null && this.armorInventory[j].getItem() instanceof ItemArmor) {
                if (this.armorInventory[j].itemID != 371 && this.armorInventory[j].itemID != 372 && this.armorInventory[j].itemID != 373 && this.armorInventory[j].itemID != 374) {
                    this.armorInventory[j].damageItem(i);
                }
                if (this.armorInventory[j].stackSize == 0) {
                    this.armorInventory[j].func_1097_a(this.player);
                    this.armorInventory[j] = null;
                }
            }
            ++j;
        }
    }

    public void func_503_g() {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] != null) {
                this.player.dropInventory(this.mainInventory[i], true);
                this.mainInventory[i] = null;
            }
            ++i;
        }
        int j = 0;
        while (j < this.armorInventory.length) {
            if (this.armorInventory[j] != null) {
                this.player.dropInventory(this.armorInventory[j], true);
                this.armorInventory[j] = null;
            }
            ++j;
        }
    }

    @Override
    public void onInventoryChanged() {
        this.inventoryChanged = true;
    }

    public boolean func_500_a(InventoryPlayer inventoryplayer) {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (!this.func_501_a(inventoryplayer.mainInventory[i], this.mainInventory[i])) {
                return false;
            }
            ++i;
        }
        int j = 0;
        while (j < this.armorInventory.length) {
            if (!this.func_501_a(inventoryplayer.armorInventory[j], this.armorInventory[j])) {
                return false;
            }
            ++j;
        }
        int k = 0;
        while (k < this.craftingInventory.length) {
            if (!this.func_501_a(inventoryplayer.craftingInventory[k], this.craftingInventory[k])) {
                return false;
            }
            ++k;
        }
        return true;
    }

    private boolean func_501_a(ItemStack itemstack, ItemStack itemstack1) {
        if (itemstack == null && itemstack1 == null) {
            return true;
        }
        if (itemstack == null || itemstack1 == null) {
            return false;
        }
        return itemstack.itemID == itemstack1.itemID && itemstack.stackSize == itemstack1.stackSize && itemstack.itemDamage == itemstack1.itemDamage;
    }

    public InventoryPlayer func_512_i() {
        InventoryPlayer inventoryplayer = new InventoryPlayer(null);
        int i = 0;
        while (i < this.mainInventory.length) {
            inventoryplayer.mainInventory[i] = this.mainInventory[i] == null ? null : this.mainInventory[i].copy();
            ++i;
        }
        int j = 0;
        while (j < this.armorInventory.length) {
            inventoryplayer.armorInventory[j] = this.armorInventory[j] == null ? null : this.armorInventory[j].copy();
            ++j;
        }
        int k = 0;
        while (k < this.craftingInventory.length) {
            inventoryplayer.craftingInventory[k] = this.craftingInventory[k] == null ? null : this.craftingInventory[k].copy();
            ++k;
        }
        return inventoryplayer;
    }

    public void setItemStack(ItemStack itemstack) {
        this.itemStack = itemstack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

