/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.tile;

import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFurnace;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;

public class TileEntityFurnace
extends TileEntity
implements IInventory {
    private ItemStack[] field_833_a = new ItemStack[3];
    private int field_832_b = 0;
    private int field_835_c = 0;
    private int field_834_d = 0;

    @Override
    public int getSizeInventory() {
        return this.field_833_a.length;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this.field_833_a[i];
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.field_833_a[i] != null) {
            if (this.field_833_a[i].stackSize <= j) {
                ItemStack itemstack = this.field_833_a[i];
                this.field_833_a[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.field_833_a[i].splitStack(j);
            if (this.field_833_a[i].stackSize == 0) {
                this.field_833_a[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.field_833_a[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public String getInvName() {
        return "Chest";
    }

    @Override
    public void func_482_a(NBTTagCompound nbttagcompound) {
        super.func_482_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_753_l("Items");
        this.field_833_a = new ItemStack[this.getSizeInventory()];
        int i = 0;
        while (i < nbttaglist.func_740_c()) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_741_a(i);
            byte byte0 = nbttagcompound1.func_746_c("Slot");
            if (byte0 >= 0 && byte0 < this.field_833_a.length) {
                this.field_833_a[byte0] = new ItemStack(nbttagcompound1);
            }
            ++i;
        }
        this.field_832_b = nbttagcompound.func_745_d("BurnTime");
        this.field_834_d = nbttagcompound.func_745_d("CookTime");
        this.field_835_c = this.func_488_a(this.field_833_a[1]);
    }

    @Override
    public void func_481_b(NBTTagCompound nbttagcompound) {
        super.func_481_b(nbttagcompound);
        nbttagcompound.func_749_a("BurnTime", (short)this.field_832_b);
        nbttagcompound.func_749_a("CookTime", (short)this.field_834_d);
        NBTTagList nbttaglist = new NBTTagList();
        int i = 0;
        while (i < this.field_833_a.length) {
            if (this.field_833_a[i] != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)i);
                this.field_833_a[i].writeToNBT(nbttagcompound1);
                nbttaglist.func_742_a(nbttagcompound1);
            }
            ++i;
        }
        nbttagcompound.func_762_a("Items", nbttaglist);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public int func_490_a(int i) {
        return this.field_834_d * i / 200;
    }

    public int func_489_b(int i) {
        if (this.field_835_c == 0) {
            this.field_835_c = 200;
        }
        return this.field_832_b * i / this.field_835_c;
    }

    public boolean func_485_a() {
        return this.field_832_b > 0;
    }

    @Override
    public void func_475_b() {
        boolean flag = this.field_832_b > 0;
        boolean flag1 = false;
        if (this.field_832_b > 0) {
            --this.field_832_b;
        }
        if (!this.world.multiplayerWorld) {
            if (this.field_832_b == 0 && this.func_491_j()) {
                this.field_835_c = this.field_832_b = this.func_488_a(this.field_833_a[1]);
                if (this.field_832_b > 0) {
                    flag1 = true;
                    if (this.field_833_a[1] != null) {
                        --this.field_833_a[1].stackSize;
                        if (this.field_833_a[1].stackSize == 0) {
                            this.field_833_a[1] = null;
                        }
                    }
                }
            }
            if (this.func_485_a() && this.func_491_j()) {
                ++this.field_834_d;
                if (this.field_834_d == 200) {
                    this.field_834_d = 0;
                    this.func_487_i();
                    flag1 = true;
                }
            } else {
                this.field_834_d = 0;
            }
            if (flag != this.field_832_b > 0) {
                flag1 = true;
                BlockFurnace.func_285_a(this.field_832_b > 0, this.world, this.x, this.y, this.z);
            }
        }
        if (flag1) {
            this.onInventoryChanged();
        }
    }

    private boolean func_491_j() {
        if (this.field_833_a[0] == null) {
            return false;
        }
        int i = this.func_486_d(this.field_833_a[0].getItem().shiftedIndex);
        if (i < 0) {
            return false;
        }
        if (this.field_833_a[2] == null) {
            return true;
        }
        if (this.field_833_a[2].itemID != i) {
            return false;
        }
        if (this.field_833_a[2].stackSize < this.getInventoryStackLimit() && this.field_833_a[2].stackSize < this.field_833_a[2].getMaxStackSize()) {
            return true;
        }
        return this.field_833_a[2].stackSize < Item.itemsList[i].func_200_b();
    }

    public void func_487_i() {
        if (!this.func_491_j()) {
            return;
        }
        int i = this.func_486_d(this.field_833_a[0].getItem().shiftedIndex);
        if (this.field_833_a[2] == null) {
            this.field_833_a[2] = new ItemStack(i, 1);
        } else if (this.field_833_a[2].itemID == i) {
            ++this.field_833_a[2].stackSize;
        }
        --this.field_833_a[0].stackSize;
        if (this.field_833_a[0].stackSize <= 0) {
            this.field_833_a[0] = null;
        }
    }

    private int func_486_d(int i) {
        if (i == Block.oreIron.blockID) {
            return Item.ingotIron.shiftedIndex;
        }
        if (i == Block.oreGold.blockID) {
            return Item.ingotGold.shiftedIndex;
        }
        if (i == Block.oreDiamond.blockID) {
            return Item.diamond.shiftedIndex;
        }
        if (i == Block.oreSeecret.blockID) {
            return Item.resourceSeecret.shiftedIndex;
        }
        if (i == Block.sand.blockID) {
            return Block.glass.blockID;
        }
        if (i == Item.porkRaw.shiftedIndex) {
            return Item.porkCooked.shiftedIndex;
        }
        if (i == Block.cobblestone.blockID) {
            return Block.stone.blockID;
        }
        if (i == Item.clay.shiftedIndex) {
            return Item.brick.shiftedIndex;
        }
        if (i == Block.wood.blockID) {
            return Item.coal.shiftedIndex;
        }
        if (i == Block.cactus.blockID) {
            return Item.dyeGreen.shiftedIndex;
        }
        if (i == Item.egg.shiftedIndex) {
            return Item.eggCooked.shiftedIndex;
        }
        return -1;
    }

    private int func_488_a(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        int i = itemstack.getItem().shiftedIndex;
        if (i < 256 && Block.allBlocks[i].blockMaterial == Material.wood) {
            return 300;
        }
        if (i == Item.stick.shiftedIndex) {
            return 100;
        }
        if (i == Item.coal.shiftedIndex) {
            return 1600;
        }
        return i != Item.bucketLava.shiftedIndex ? 0 : 20000;
    }
}

