/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPickupFX;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.gui.GuiChest;
import com.mojang.minecraft.gui.GuiCrafting;
import com.mojang.minecraft.gui.GuiEditSign;
import com.mojang.minecraft.gui.GuiFurnace;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.player.controller.MovementInput;
import com.mojang.minecraft.sound.AmbientLoopHandler;
import com.mojang.minecraft.util.MathHelper;
import com.mojang.minecraft.util.Session;
import com.mojang.minecraft.util.SkinUrlGetPost;

public class EntityPlayerSP
extends EntityPlayer {
    public MovementInput currentInput;
    private Minecraft mc;
    public AmbientLoopHandler loopHandler;

    public EntityPlayerSP(Minecraft minecraft, World world, Session session) {
        super(world);
        this.mc = minecraft;
        if (session != null && session.username != null && session.username.length() > 0) {
            try {
                this.skinURL = SkinUrlGetPost.getPostUrl(session.username);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Loading texture " + this.skinURL);
        }
        this.playerName = session.username;
        this.loopHandler = new AmbientLoopHandler(world, this);
    }

    @Override
    public void updateEntityActionState() {
        super.updateEntityActionState();
        this.movingLeftRight = this.currentInput.movementLeftRight;
        this.movingForwardBack = this.currentInput.movementForwardBack;
        this.isJumping = this.currentInput.movementIsJumping;
        this.isRunning = this.currentInput.movementIsRunning;
    }

    private float getDirection() {
        int yaw1;
        float yaw = this.mc.thePlayer.rotationYaw;
        float moveForward = this.mc.thePlayer.movingForwardBack;
        float moveStrafing = this.mc.thePlayer.movingLeftRight;
        yaw += (float)(moveForward < 0.0f ? 180 : 0);
        int n = moveForward == 0.0f ? 90 : (yaw1 = moveForward < 0.0f ? -45 : 45);
        if (moveStrafing < 0.0f) {
            yaw += (float)yaw1;
        }
        if (moveStrafing > 0.0f) {
            yaw -= (float)yaw1;
        }
        return yaw * ((float)Math.PI / 180);
    }

    public double getSpeed() {
        return Math.sqrt(MathHelper.square(this.motionX) + MathHelper.square(this.motionZ));
    }

    public void setSpeed(double speed) {
        this.mc.thePlayer.motionX = (double)(-MathHelper.sin(this.getDirection())) * speed;
        this.mc.thePlayer.motionZ = (double)MathHelper.cos(this.getDirection()) * speed;
    }

    @Override
    public void entityMove() {
        this.currentInput.func_797_a(this);
        if (this.currentInput.movementIsSneaking && this.ySize < 0.2f) {
            this.ySize = 0.2f;
        }
        if (this.isRunning && (this.currentInput.movementForwardBack != 0.0f || this.currentInput.movementLeftRight != 0.0f) && this.worldObj.difficulty < 3 && this.entityBeingRidden == null && !this.isInWater()) {
            this.setSpeed(0.2);
        }
        super.entityMove();
    }

    public void func_458_k() {
        this.currentInput.func_798_a();
    }

    @Override
    public void func_460_a(int i, boolean flag) {
        this.currentInput.func_796_a(i, flag);
    }

    @Override
    public void addNBTTag(NBTTagCompound nbttagcompound) {
        super.addNBTTag(nbttagcompound);
        nbttagcompound.setInteger("Score", this.field_776_d);
    }

    @Override
    public void removeNBTTag(NBTTagCompound nbttagcompound) {
        super.removeNBTTag(nbttagcompound);
        this.field_776_d = nbttagcompound.func_756_e("Score");
    }

    @Override
    public void displayGUIChest(IInventory iinventory) {
        this.mc.setCurrentScreen(new GuiChest(this.inventory, iinventory));
    }

    @Override
    public void func_455_a(TileEntitySign tileentitysign) {
        this.mc.setCurrentScreen(new GuiEditSign(tileentitysign));
    }

    @Override
    public void displayWorkbenchGUI() {
        this.mc.setCurrentScreen(new GuiCrafting(this.inventory));
    }

    @Override
    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
        this.mc.setCurrentScreen(new GuiFurnace(this.inventory, tileentityfurnace));
    }

    public void attackEntity(Entity entity) {
        int i = this.inventory.func_502_a(entity);
        if (i > 0) {
            entity.attacked(this, i);
            ItemStack itemstack = this.thrownItem();
            if (itemstack != null && entity instanceof EntityLiving) {
                itemstack.hitEntity((EntityLiving)entity);
                if (itemstack.stackSize <= 0) {
                    itemstack.func_1097_a(this);
                    this.func_448_u();
                }
            }
        }
    }

    @Override
    public void onEntityUpdate() {
        super.onEntityUpdate();
        this.loopHandler.update();
    }

    @Override
    public void func_443_a_(Entity entity, int i) {
        this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.mcWorld, entity, this, -0.5f));
    }

    public int func_459_m() {
        return this.inventory.func_506_f();
    }

    @Override
    public void interactWithEntity(Entity entity) {
        if (entity.checkRide(this)) {
            return;
        }
        ItemStack itemstack = this.thrownItem();
        if (itemstack != null && entity instanceof EntityLiving) {
            itemstack.useItemOnEntity((EntityLiving)entity);
            if (itemstack.stackSize <= 0) {
                itemstack.func_1097_a(this);
                this.func_448_u();
            }
        }
    }

    public void sendChatMessage(String s) {
    }

    public void func_462_n() {
    }

    @Override
    public boolean getIsSneaking() {
        return this.currentInput.movementIsSneaking;
    }

    @Override
    public double getRealMoveSpeed() {
        if (this.isRunning) {
            return 0.75;
        }
        return 0.5;
    }

    @Override
    public int posXInt() {
        return (int)Math.round(this.posX);
    }

    @Override
    public int posYInt() {
        return (int)Math.round(this.posY);
    }

    @Override
    public int posZInt() {
        return (int)Math.round(this.posZ);
    }

    public void setHealth(int healthMP) {
        this.health = healthMP;
    }

    public void closeScreen() {
    }
}

