/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityArrow;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityMobs;
import com.mojang.minecraft.entity.item.Container;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.WorldClient;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.player.controller.MovementInput;
import com.mojang.minecraft.player.inventory.InventoryPlayer;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;

public class EntityPlayer
extends EntityLiving {
    public InventoryPlayer inventory = new InventoryPlayer(this);
    public MovementInput currentInput;
    public Container inventorySlots;
    public Container craftingInventory;
    public byte field_777_c = 0;
    public int field_776_d = 0;
    public float field_775_e;
    public float field_774_f;
    public boolean field_773_g = false;
    public int field_772_h = 0;
    public String playerName = "";
    private int field_779_a = 0;

    public EntityPlayer(World world) {
        super(world);
        this.eyeHeight = 1.62f;
        this.spawnNewEntity((double)world.spawnX + 0.5, world.spawnY + 1, (double)world.spawnZ + 0.5, 0.0f, 0.0f);
        this.health = 20;
        this.field_725_x = "humanoid";
        this.field_726_w = 180.0f;
        this.fireResistance = 20;
        this.texture = "/char.png";
        this.spongeArmor = 0;
    }

    public int posXInt() {
        return (int)Math.round(this.posX);
    }

    public int posYInt() {
        return (int)Math.round(this.posY);
    }

    public int posZInt() {
        return (int)Math.round(this.posZ);
    }

    @Override
    public void func_350_p() {
        super.func_350_p();
        this.field_775_e = this.field_774_f;
        this.field_774_f = 0.0f;
    }

    @Override
    public void func_374_q() {
        this.eyeHeight = 1.62f;
        this.setBounds(0.6f, 1.8f);
        super.func_374_q();
        this.health = 20;
        this.deathTime = 0;
    }

    @Override
    protected void updateEntityActionState() {
        if (this.field_773_g) {
            ++this.field_772_h;
            if (this.field_772_h == 8) {
                this.field_772_h = 0;
                this.field_773_g = false;
            }
        } else {
            this.field_772_h = 0;
        }
        this.field_718_D = (float)this.field_772_h / 8.0f;
    }

    @Override
    public void entityMove() {
        List<Entity> list;
        int spongeCount;
        if (!(this.worldObj instanceof WorldClient) && this.worldObj.difficulty == 0 && this.health < 20 && this.ticksExisted % 20 * 4 == 0) {
            this.heal(1);
        }
        this.spongeArmor = spongeCount = this.inventory.getSpongeCount();
        this.inventory.func_511_b();
        this.field_775_e = this.field_774_f;
        super.entityMove();
        float hypotenuseMove = MathHelper.squareRootDoubleToFloat(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float f1 = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (hypotenuseMove > 0.15f) {
            hypotenuseMove = 0.15f;
        }
        if (!this.onGround || this.health <= 0) {
            hypotenuseMove = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            f1 = 0.0f;
        }
        this.field_774_f += (hypotenuseMove - this.field_774_f) * 0.4f;
        this.field_709_M += (f1 - this.field_709_M) * 0.8f;
        if (this.health > 0 && (list = this.worldObj.func_659_b(this, this.boundingBox.func_1177_b(1.0, 0.0, 1.0))) != null) {
            int i = 0;
            while (i < list.size()) {
                this.func_451_h(list.get(i));
                ++i;
            }
        }
        if (this.posY < -64.0) {
            this.health -= 4;
        }
    }

    private void func_451_h(Entity entity) {
        entity.func_362_b(this);
    }

    public int func_447_r() {
        return this.field_776_d;
    }

    @Override
    public void died(Entity entity) {
        this.setBounds(0.2f, 0.2f);
        this.moveToPosDouble(this.posX, this.posY, this.posZ);
        this.motionY = 0.1f;
        if (this.playerName.equals("Hatsune_Miku")) {
            this.dropInventory(new ItemStack(Item.appleRed, 1), true);
        }
        this.inventory.func_503_g();
        if (entity != null) {
            this.motionX = -MathHelper.cos((this.field_713_I + this.rotationYaw) * 3.141593f / 180.0f) * 0.1f;
            this.motionZ = -MathHelper.sin((this.field_713_I + this.rotationYaw) * 3.141593f / 180.0f) * 0.1f;
        } else {
            this.motionZ = 0.0;
            this.motionX = 0.0;
        }
        this.eyeHeight = 0.1f;
    }

    @Override
    public void func_364_b(Entity entity, int i) {
        this.field_776_d += i;
    }

    public void dropPlayerItem(ItemStack itemstack) {
        this.dropInventory(itemstack, false);
    }

    public void dropInventory(ItemStack itemstack, boolean flag) {
        if (itemstack == null) {
            return;
        }
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY - (double)0.3f + (double)this.func_373_s(), this.posZ, itemstack);
        entityitem.delayBeforeCanPickup = 40;
        if (flag) {
            float f2 = this.rand.nextFloat() * 0.5f;
            float f4 = this.rand.nextFloat() * 3.141593f * 2.0f;
            entityitem.motionX = -MathHelper.sin(f4) * f2;
            entityitem.motionZ = MathHelper.cos(f4) * f2;
            entityitem.motionY = 0.2f;
        } else {
            float f1 = 0.3f;
            entityitem.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f1;
            entityitem.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f1;
            entityitem.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * 3.141593f) * f1 + 0.1f;
            f1 = 0.02f;
            float f3 = this.rand.nextFloat() * 3.141593f * 2.0f;
            entityitem.motionX += Math.cos(f3) * (double)(f1 *= this.rand.nextFloat());
            entityitem.motionY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
            entityitem.motionZ += Math.sin(f3) * (double)f1;
        }
        this.func_446_a(entityitem);
    }

    protected void func_446_a(EntityItem entityitem) {
        this.worldObj.entityJoinedWorld(entityitem);
    }

    public float getMiningInhibitors(Block block) {
        float f = this.inventory.func_508_a(block);
        if (this.headSpaceMaterial(Material.water)) {
            f = this.spongeArmor > 0 ? (f /= (float)(5 - this.spongeArmor)) : (f /= 5.0f);
        }
        if (!this.onGround) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean checkBreakBlock(Block block) {
        return this.inventory.blockBreakCheck(block);
    }

    public boolean checkGoldTouch(Block block) {
        return this.inventory.blockGoldTouchCheck(block);
    }

    @Override
    public void removeNBTTag(NBTTagCompound nbttagcompound) {
        super.removeNBTTag(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_753_l("Inventory");
        this.inventory.func_513_b(nbttaglist);
    }

    @Override
    public void addNBTTag(NBTTagCompound nbttagcompound) {
        super.addNBTTag(nbttagcompound);
        nbttagcompound.func_762_a("Inventory", this.inventory.func_493_a(new NBTTagList()));
    }

    public void displayGUIChest(IInventory iinventory) {
    }

    public void displayWorkbenchGUI() {
    }

    public void func_443_a_(Entity entity, int i) {
    }

    @Override
    protected float func_373_s() {
        return 0.12f;
    }

    @Override
    public boolean attacked(Entity entity, int damage) {
        this.field_701_U = 0;
        if (this.health <= 0) {
            return false;
        }
        if ((float)this.heartsLife > (float)this.maxHealth / 2.0f) {
            return false;
        }
        if (entity instanceof EntityMobs || entity instanceof EntityArrow) {
            if (this.worldObj.difficulty == 0) {
                damage = 0;
            }
            if (this.worldObj.difficulty == 1) {
                damage = damage / 3 + 1;
            }
            if (this.worldObj.difficulty == 3) {
                damage = damage * 3 / 2;
            }
        }
        int j = 25 - this.inventory.func_506_f();
        int k = damage * j + this.field_779_a;
        this.inventory.func_507_e(damage);
        damage = k / 25;
        this.field_779_a = k % 25;
        if (damage == 0) {
            return false;
        }
        return super.attacked(entity, damage);
    }

    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
    }

    public void func_455_a(TileEntitySign tileentitysign) {
    }

    public void interactWithEntity(Entity entity) {
    }

    public ItemStack thrownItem() {
        return this.inventory.getCurrentItem();
    }

    public void func_448_u() {
        this.inventory.setInventorySlotContents(this.inventory.currentItem, null);
    }

    @Override
    public double func_388_v() {
        return this.eyeHeight - 0.5f;
    }

    public void swingItem() {
        this.field_772_h = -1;
        this.field_773_g = true;
    }

    public void func_460_a(int eventKey, boolean eventKeyState) {
    }
}

