/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.game.level.server;

import net.minecraft.game.level.server.MCHashEntry;

public class MCHash {
    private transient MCHashEntry[] slots = new MCHashEntry[16];
    private transient int count;
    private int threshold = 12;
    private final float growFactor = 0.75f;
    private volatile transient int versionStamp;

    private static int computeHash(int n2) {
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        return n2 ^ n2 >>> 7 ^ n2 >>> 4;
    }

    private static int getSlotIndex(int n2, int n3) {
        return n2 & n3 - 1;
    }

    public Object lookup(int n2) {
        int n3 = MCHash.computeHash(n2);
        MCHashEntry mCHashEntry = this.slots[MCHash.getSlotIndex(n3, this.slots.length)];
        while (mCHashEntry != null) {
            if (mCHashEntry.hashEntry == n2) {
                return mCHashEntry.valueEntry;
            }
            mCHashEntry = mCHashEntry.nextEntry;
        }
        return null;
    }

    public void addKey(int n2, Object object) {
        int n3 = MCHash.computeHash(n2);
        int n4 = MCHash.getSlotIndex(n3, this.slots.length);
        MCHashEntry mCHashEntry = this.slots[n4];
        while (mCHashEntry != null) {
            if (mCHashEntry.hashEntry == n2) {
                mCHashEntry.valueEntry = object;
            }
            mCHashEntry = mCHashEntry.nextEntry;
        }
        ++this.versionStamp;
        this.insert(n3, n2, object, n4);
    }

    private void grow(int n2) {
        MCHashEntry[] mCHashEntryArray = this.slots;
        int n3 = mCHashEntryArray.length;
        if (n3 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        MCHashEntry[] mCHashEntryArray2 = new MCHashEntry[n2];
        this.copyTo(mCHashEntryArray2);
        this.slots = mCHashEntryArray2;
        this.threshold = (int)((float)n2 * 0.75f);
    }

    private void copyTo(MCHashEntry[] mCHashEntryArray) {
        MCHashEntry[] mCHashEntryArray2 = this.slots;
        int n2 = mCHashEntryArray.length;
        for (int i2 = 0; i2 < mCHashEntryArray2.length; ++i2) {
            MCHashEntry mCHashEntry;
            MCHashEntry mCHashEntry2 = mCHashEntryArray2[i2];
            if (mCHashEntry2 == null) continue;
            mCHashEntryArray2[i2] = null;
            do {
                mCHashEntry = mCHashEntry2.nextEntry;
                int n3 = MCHash.getSlotIndex(mCHashEntry2.slotHash, n2);
                mCHashEntry2.nextEntry = mCHashEntryArray[n3];
                mCHashEntryArray[n3] = mCHashEntry2;
            } while ((mCHashEntry2 = mCHashEntry) != null);
        }
    }

    public Object removeObject(int n2) {
        MCHashEntry mCHashEntry = this.removeEntry(n2);
        return mCHashEntry != null ? mCHashEntry.valueEntry : null;
    }

    final MCHashEntry removeEntry(int n2) {
        MCHashEntry mCHashEntry;
        int n3 = MCHash.computeHash(n2);
        int n4 = MCHash.getSlotIndex(n3, this.slots.length);
        MCHashEntry mCHashEntry2 = mCHashEntry = this.slots[n4];
        while (mCHashEntry2 != null) {
            MCHashEntry mCHashEntry3 = mCHashEntry2.nextEntry;
            if (mCHashEntry2.hashEntry == n2) {
                ++this.versionStamp;
                --this.count;
                if (mCHashEntry == mCHashEntry2) {
                    this.slots[n4] = mCHashEntry3;
                } else {
                    mCHashEntry.nextEntry = mCHashEntry3;
                }
                return mCHashEntry2;
            }
            mCHashEntry = mCHashEntry2;
            mCHashEntry2 = mCHashEntry3;
        }
        return mCHashEntry2;
    }

    public void clearMap() {
        ++this.versionStamp;
        MCHashEntry[] mCHashEntryArray = this.slots;
        for (int i2 = 0; i2 < mCHashEntryArray.length; ++i2) {
            mCHashEntryArray[i2] = null;
        }
        this.count = 0;
    }

    private void insert(int n2, int n3, Object object, int n4) {
        MCHashEntry mCHashEntry = this.slots[n4];
        this.slots[n4] = new MCHashEntry(n2, n3, object, mCHashEntry);
        if (this.count++ >= this.threshold) {
            this.grow(2 * this.slots.length);
        }
    }

    static int getHash(int n2) {
        return MCHash.computeHash(n2);
    }
}

