/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class ImageBufferDownload {
    private int[] imageData;
    private int imageWidth;
    private int imageHeight;

    public BufferedImage parseUserSkin(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        this.imageWidth = 128;
        this.imageHeight = 128;
        BufferedImage bufferedImage2 = new BufferedImage(this.imageWidth, this.imageHeight, 2);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        this.imageData = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
        this.setAreaOpaque(0, 0, 32, 16);
        this.setAreaTransparent(32, 0, 64, 32);
        this.setAreaOpaque(0, 16, 64, 32);
        return bufferedImage2;
    }

    private void setAreaTransparent(int n2, int n3, int n4, int n5) {
        boolean bl;
        int n6 = 32;
        int n7 = 64;
        int n8 = 0;
        int n9 = 32;
        ImageBufferDownload imageBufferDownload = this;
        n3 = n9;
        block0: while (true) {
            if (n3 >= n7) {
                bl = false;
                break;
            }
            for (int i2 = n8; i2 < n6; ++i2) {
                if (imageBufferDownload.imageData[n3 + i2 * imageBufferDownload.imageWidth] >>> 24 >= 128) continue;
                bl = true;
                break block0;
            }
            ++n3;
        }
        if (!bl) {
            for (n2 = 32; n2 < 64; ++n2) {
                for (n3 = 0; n3 < 32; ++n3) {
                    int n10 = n2 + n3 * this.imageWidth;
                    this.imageData[n10] = this.imageData[n10] & 0xFFFFFF;
                }
            }
        }
    }

    private void setAreaOpaque(int n2, int n3, int n4, int n5) {
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i2 = n3; i2 < n5; ++i2) {
                int n6 = n2 + i2 * this.imageWidth;
                this.imageData[n6] = this.imageData[n6] | 0xFF000000;
            }
        }
    }
}

