import java.applet.Applet;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

import javax.swing.JFrame;
import javax.swing.JLabel;

import org.betacraft.Addon;
import org.betacraft.Wrapper;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.ReleaseJson;

public class NSSS_1 extends Wrapper {

	public NSSS_1(String user, String ver_prefix, String version, String sessionid, String mainFolder, Integer height,
			Integer width, Boolean RPC, String launchMethod, String server, String mppass, String uuid, String USR, String VER,
			Image img, ArrayList addons) {
		super(user, ver_prefix, version, sessionid, mainFolder, height, width, RPC, launchMethod, server, mppass, uuid, USR, VER, img,
				addons);
	}

	@Override
	public void loadMainClass(URL[] url) {
		classLoader = new URLClassLoader(url);
		try {
			mainClass = classLoader.loadClass("com.mojang.minecraft.MinecraftApplet");
			mainClassInstance = (Applet) mainClass.newInstance();
			try {
				for (Class<Addon> c : ogaddons) {
					this.loadAddon((Addon) c.newInstance());
					System.out.println("- " + c);
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	@Override
	public void loadJars() {
		try {
			String[] libs = new File(BC.get(), "bin/").list(new FilenameFilter() {
				public boolean accept(File dir, String fileName) {
					return fileName.endsWith(".jar");
				}
			});

			// Glue everything Minecraft needs for running
			String[] files = new String[libs.length + 2];

			files[0] = BC.get() + "versions/" + version + ".jar";
			files[1] = BC.get() + "versions/a1.1.2_01.jar";

			for (int i = 0; i < libs.length; i++) {
				files[i + 2] = BC.get() + "bin/" + libs[i];
			}

			String nativesPath = BC.get() + "bin/natives";
			System.setProperty("org.lwjgl.librarypath", nativesPath);
			System.setProperty("net.java.games.input.librarypath", nativesPath);

			final URL[] url = new URL[files.length];
			for (int i = 0; i < files.length; i++) {
				System.out.println(files[i]);
				url[i] = new File(files[i]).toURI().toURL();
			}

			loadMainClass(url);
			launchType = "indev";
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	@Override
	public void play() {
		try {
			System.clearProperty("http.proxyHost");
			System.clearProperty("http.proxyPort");
			File a11201 = new File(BC.get() + "versions", "a1.1.2_01.jar");
			if (!a11201.exists()) {
				ReleaseJson json = new ReleaseJson("a1.1.2_01");
				if (!ReleaseJson.exists("a1.1.2_01")) json.downloadJson();
				json = new ReleaseJson("a1.1.2_01");
				JFrame frame = new JFrame("Downloading dependencies...");
				frame.setLayout(new GridBagLayout());
				frame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
				JLabel infolabel = new JLabel("Downloading: a1.1.2_01 (" + json.getDownloadURL() + ")");
				GridBagConstraints constr = new GridBagConstraints();

				constr.gridx = 0;
				constr.gridy = 0;
				constr.fill = GridBagConstraints.HORIZONTAL;
				constr.gridwidth = 1;
				constr.weightx = 1.0;
				constr.insets = new Insets(10, 10, 10, 10);

				frame.add(infolabel, constr);
				frame.pack();

				frame.setIconImage(this.icon);
				frame.setLocationRelativeTo(null);
				frame.setVisible(true);
				if (Launcher.download(json.getDownloadURL(), a11201) == DownloadResult.FAILED_WITHOUT_BACKUP) {
					infolabel.setText("Failed to download! Check your Internet connection!");
					frame.setTitle("Failed!");
				} else {
					frame.setVisible(false);
				}
			}

			super.play();
		} catch (Exception ex) {
			System.out.println("A critical error has occurred!");
			System.out.print(ex.toString());
		}
	}
}
