import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.JFrame;
import javax.swing.JLabel;

import org.betacraft.Wrapper;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import uk.betacraft.auth.CustomRequest;

public class NFC extends Wrapper {
	public File nfcdepends;

	public NFC(String user, String ver_prefix, String version, String sessionid, String mainFolder,
			Integer height, Integer width, Boolean RPC, String launchMethod, String server, String mppass, String uuid, String USR,
			String VER, Image img, ArrayList addons) {
		super(user, ver_prefix, version, sessionid, mainFolder, height, width, RPC, launchMethod, server, mppass, uuid, USR, VER, img,
				addons);
	}

	@Override
	public void loadJars() {
		String[] nfclibs = this.updateDepends();

		// Back to normal method;
		try {
			String[] lwjgllibs = new File(BC.get(), "bin/").list(new FilenameFilter() {
				public boolean accept(File dir, String fileName) {
					return fileName.endsWith(".jar");
				}
			});

			// Glue everything Minecraft needs for running
			String[] files = new String[1 + (this.libraries_loaded ? 0 : lwjgllibs.length) + nfclibs.length];

			files[0] = BC.get() + "versions/" + version + ".jar";

			// Load NFC libs first
			int offset = 0;
			for (int i = 0; i < nfclibs.length; i++) {
				files[i + 1] = new File(nfcdepends, nfclibs[i]).getAbsolutePath();
				offset++;
			}

			// Then, lwjgl
			if (!this.libraries_loaded) {
				for (int i = 0; i < lwjgllibs.length; i++) {
					files[i + 1 + offset] = BC.get() + "bin/" + lwjgllibs[i];
				}
			}

			String nativesPath = BC.get() + "bin/natives";
			System.setProperty("org.lwjgl.librarypath", nativesPath);
			System.setProperty("net.java.games.input.librarypath", nativesPath);

			System.out.println();
			System.out.println("Classpath:");
			final URL[] url = new URL[files.length];
			for (int i = 0; i < files.length; i++) {
				System.out.println(files[i]);
				url[i] = new File(files[i]).toURI().toURL();
			}
			System.out.println();

			loadMainClass(url);
		} catch (Throwable t) {
			t.printStackTrace();
		}
	}

	public String[] updateDepends() {
		nfcdepends = new File(Launcher.getVerFolder(), "mods/NFC_v1/");
		nfcdepends.mkdirs();

		// display some info to the user
		JFrame frame = new JFrame("Downloading dependencies...");
		frame.setLayout(new GridBagLayout());
		frame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		frame.setPreferredSize(new java.awt.Dimension(500, 100));
		JLabel infolabel = new JLabel("Downloading...");
		GridBagConstraints constr = new GridBagConstraints();

		constr.gridx = 0;
		constr.gridy = 0;
		constr.fill = GridBagConstraints.HORIZONTAL;
		constr.gridwidth = 1;
		constr.weightx = 1.0;
		constr.insets = new Insets(10, 10, 10, 10);

		frame.add(infolabel, constr);
		frame.pack();

		frame.setIconImage(this.icon);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);

		JsonArray rootarray = getTreeArray("https://api.github.com/repos/New-Frontier-Craft/New-Frontier-Craft/git/trees/master");
		if (rootarray == null) {
			System.err.println("Failed to fetch libraries from Github (#1). Will attempt to launch, but can't guarantee success!");

			infolabel.setText("Failed to fetch library list. This may make your game unplayable");
			frame.setTitle("Failed!");

			return nfcdepends.list(new FilenameFilter() {
				public boolean accept(File dir, String fileName) {
					return fileName.endsWith(".jar");
				}
			});
		} else {
			// Attempt to locate the lib directory
			String libUrl = null;

			Iterator<JsonElement> iterator = rootarray.iterator();
			while (iterator.hasNext()) {
				JsonObject entry = iterator.next().getAsJsonObject();
				String path = entry.get("path").getAsString();

				if (path.equals("lib")) {
					libUrl = entry.get("url").getAsString();
					break;
				}
			}

			if (libUrl == null) {
				System.err.println("Failed to fetch libraries from Github (#2). Will attempt to launch, but can't guarantee success!");

				infolabel.setText("NFC lib storage directory changed. Contact NFC developers.");
				frame.setTitle("Failed!");

				return nfcdepends.list(new FilenameFilter() {
					public boolean accept(File dir, String fileName) {
						return fileName.endsWith(".jar");
					}
				});
			} else {
				JsonArray libarray = getTreeArray(libUrl);
				Iterator<JsonElement> libiterator = libarray.iterator();

				ArrayList<String> paths = new ArrayList<String>();
				while (libiterator.hasNext()) {
					JsonObject lib = libiterator.next().getAsJsonObject();
					long size = lib.get("size").getAsLong();
					String path = lib.get("path").getAsString();
					boolean isBlob = lib.get("type").getAsString().equals("blob");

					// update the user
					infolabel.setText("Downloading: " + path);
					paths.add(path);

					if (isBlob && !isDependUpToDate(path, size)) {
						boolean success = downloadDepend(path, size);
						if (!success) {
							System.err.println("Failed to download '" + path + "'");
						}
					}
				}

				// Done
				frame.dispose();

				return paths.toArray(new String[0]);
			}
		}
	}

	public File getDependFromPath(String path) {
		return new File(nfcdepends, path);
	}

	public boolean isDependUpToDate(String relativePath, long length) {
		File given = getDependFromPath(relativePath);
		if (!given.exists() || given.length() != length) {
			return false;
		}

		return true;
	}

	public boolean downloadDepend(String relativePath, long expectedLength) {
		String url = "https://github.com/New-Frontier-Craft/New-Frontier-Craft/raw/master/lib/" + relativePath;
		File given = new File(nfcdepends, relativePath);

		DownloadResult res = Launcher.download(url, given);

		return res.isPositive() && given.length() == expectedLength;
	}

	public JsonArray getTreeArray(String url) {
		String rootresponse = new CustomRequest(url).perform().response;
		if (rootresponse == null) {
			System.err.println("Failed to fetch tree array from: " + url);
			return null;
		} else {
			JsonObject obj = Util.gson.fromJson(rootresponse, JsonObject.class);
			JsonArray treearray = obj.get("tree").getAsJsonArray();
			return treearray;
		}
	}
}
