import java.awt.Image;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

import javax.swing.JOptionPane;

import org.betacraft.Wrapper;

import uk.betacraft.auth.Request;
import uk.betacraft.auth.Request.RequestType;
import uk.betacraft.auth.RequestUtil;
import uk.betacraft.auth.Response;
import uk.betacraft.util.WebData;

public class ClassicWithSaving extends Wrapper {

	public ClassicWithSaving(String arg0, String arg1, String arg2, String arg3, String arg4, Integer arg5,
			Integer arg6, Boolean arg7, String arg8, String arg9, String arg10, String arg11, String arg12,
			String arg13, Image arg14, ArrayList arg15) {
		super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
	}

	public String getBetacraftSession() throws UnsupportedEncodingException {
		Request req = new Request() {
			public Response perform() {
				return null;
			}
		};

		req.type = RequestType.GET;
		req.REQUEST_URL = "https://api.betacraft.uk/v2/proxy_token?player=" + this.uuid;

		WebData data = RequestUtil.performRawGETRequest(req);

		if (data.getResponseCode() == -2) {
			JOptionPane.showMessageDialog(null, "You will not be able to save online.", "", JOptionPane.ERROR_MESSAGE);
		}

		return new String(data.getData(), "UTF-8");
	}

	public void authOnlineSaving() {
		// don't authenticate with level server if joining mp, fails most of the time and prevents from joining online-mode servers
		if (this.params.containsKey("server"))
			return;

		// only authenticate if not cracked
		if (this.session.equals("-"))
			return;

		this.sendJoinServerRequest("betacraft.uk");

		try {
			String betacraftSession = getBetacraftSession();

			this.params.replace("sessionid", betacraftSession);
		} catch (Throwable t) {
			t.printStackTrace();
		}
	}

	// disable that for classic
	@Override
	public void authenticateBetaEvo() {}

	@Override
	public void play() {
		this.authOnlineSaving();

		super.play();
	}
}
