import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

import org.betacraft.Addon;
import org.betacraft.Wrapper;
import org.betacraft.launcher.Logger;

public class QuitGame extends Addon {

	@Override
	public WhatToDo postAppletInit(Wrapper wrapper, ArrayList<Addon> addonsLeft) {
		try {
			for (final Field field : wrapper.mainClass.getDeclaredFields()) {
				final String name = field.getType().getName();
				if (!name.contains("awt") && !name.contains("java")) {
					Field buttonTriggerField = null;

					// Set Minecraft field accessible
					field.setAccessible(true);

					// Get the instance
					Object mc = field.get(wrapper.mainClassInstance);

					final Class<?> clazz = wrapper.classLoader.loadClass(name);
					for (final Field field1 : clazz.getDeclaredFields()) {
						if (Modifier.isPublic(field1.getModifiers())) {

							if (!field1.getType().isPrimitive()) continue;

							// The trigger field for the button is always public,
							// and is always the first to be found by this code.
							// The next public boolean field is responsible for
							// something different, so we need to stop the code
							// after we found the first occurrence.
							if (field1.getType().getName().equals("boolean")) {
								boolean bol = field1.getBoolean(mc);
								if (bol) {
									buttonTriggerField = field1;
									break;
								}
							}
						}
					}
					if (buttonTriggerField != null) {
						buttonTriggerField.setAccessible(true);
						buttonTriggerField.set(mc, false);
						break;
					}
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			Logger.printException(ex);
		}
		return WhatToDo.NORMAL;
	}
}
