import java.lang.reflect.Field;
import java.util.ArrayList;

import org.betacraft.Addon;
import org.betacraft.Wrapper;

import sun.misc.Unsafe;

public class GameModeSwitch extends Addon {

	private enum Era {
		CLASSIC,
		INDEV;
	}

	@Override
	public WhatToDo postAppletInit(final Wrapper wrapper, ArrayList<Addon> addonsLeft) {
		if (wrapper.params.get("server") != null) {
			System.err.println("[Betacraft] GameModeSwitch cannot apply when joining servers.");
			return WhatToDo.NORMAL;
		}

		if (wrapper.version.startsWith("inf-2010063")) {
			inject(Era.INDEV, wrapper, "aw", "aj", "bt");
		} else if (wrapper.version.equals("inf-20100627") || wrapper.version.equals("inf-20100629")) {
			inject(Era.INDEV, wrapper, "at", "ah", "bq");
		} else if (wrapper.version.equals("inf-20100624") || wrapper.version.startsWith("inf-20100625")) {
			inject(Era.INDEV, wrapper, "net.minecraft.client.f", "net.minecraft.client.d.b", "net.minecraft.client.d.d");
		} else if (!wrapper.version.startsWith("in-20100201") && (wrapper.version.startsWith("in-201002") || wrapper.version.startsWith("inf-20100227") || wrapper.version.startsWith("inf-201003"))) {
			inject(Era.INDEV, wrapper, "net.minecraft.client.d", "net.minecraft.client.d.a", "net.minecraft.client.d.c");
		} else if (wrapper.version.startsWith("in-201001") || wrapper.version.startsWith("in-20100201")) {
			inject(Era.INDEV, wrapper, "net.minecraft.client.d", "net.minecraft.client.c.a", "net.minecraft.client.c.c");
		} else if (wrapper.version.startsWith("in-20091223")) {
			inject(Era.CLASSIC, wrapper, "net.minecraft.client.e", "net.minecraft.client.e.a", "net.minecraft.client.e.b");
		} else if (wrapper.version.startsWith("in-20091231")) {
			inject(Era.INDEV, wrapper, "net.minecraft.client.e", "net.minecraft.client.e.a", "net.minecraft.client.e.c");
        } else if (wrapper.version.startsWith("c0.30") || wrapper.version.startsWith("c0.2")) {
        	inject(Era.CLASSIC, wrapper, "com.mojang.minecraft.l", "com.mojang.minecraft.d.b", "com.mojang.minecraft.d.c");
		}
		return WhatToDo.NORMAL;
	}

	private void inject(Era era, final Wrapper wrapper, String eMinecraftClassName, String eGamemodeMainClassName, String eGamemode2ClassName) {
		try {
			for (final Field minecraftField : wrapper.mainClass.getDeclaredFields()) {
				final String name = minecraftField.getType().getName();
				if (name.contains(eMinecraftClassName)) {

					// Access the Minecraft instance
					minecraftField.setAccessible(true);
					Object mc = minecraftField.get(wrapper.mainClassInstance);

					// Begin injecting the chosen gamemode...
					final Class<?> clazz = wrapper.classLoader.loadClass(name);
					for (final Field field1 : clazz.getDeclaredFields()) {
						if (field1.getType().getName().equals(eGamemodeMainClassName)) {
							final Class<?> clazz2 = wrapper.classLoader.loadClass(eGamemode2ClassName);
							final Class<?> clazz3 = wrapper.classLoader.loadClass(eGamemodeMainClassName);

							Field funsafe = Unsafe.class.getDeclaredField("theUnsafe");
							funsafe.setAccessible(true);
							Unsafe unsafe = (Unsafe) funsafe.get(null);
							Object gamemodeInstance = unsafe.allocateInstance(clazz2);

							// Reproduce the init method which is removed in c0.28 - creative c0.30s
							if (era == Era.CLASSIC)
								gamemodeInstance = classicInject(clazz2, clazz3, gamemodeInstance, mc);
							else if (era == Era.INDEV)
								gamemodeInstance = indevInject(clazz3, gamemodeInstance, mc);

							field1.set(mc, gamemodeInstance);
							break;
						}
					}
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	private Object indevInject(final Class<?> clazz, Object gamemodeInstance, Object minecraftInstance) {
		try {
			try {
				Field b = clazz.getDeclaredField("b"); b.setAccessible(true);
				b.set(gamemodeInstance, true);
			} catch (NoSuchFieldException e) {}

			Field a = clazz.getDeclaredField("a"); a.setAccessible(true);
			a.set(gamemodeInstance, minecraftInstance);
			return gamemodeInstance;
		} catch (Throwable t) {
			t.printStackTrace();
		}
		return null;
	}

	private Object classicInject(final Class<?> clazz, final Class<?> clazz2, Object gamemodeInstance, Object minecraftInstance) {
		try {
			Field c = clazz.getDeclaredField("c"); c.setAccessible(true);
			Field d = clazz.getDeclaredField("d"); d.setAccessible(true);
			Field e = clazz.getDeclaredField("e"); e.setAccessible(true);
			Field f = clazz.getDeclaredField("f"); f.setAccessible(true);
			Field g = clazz.getDeclaredField("g"); g.setAccessible(true);
			Field h = clazz.getDeclaredField("h"); h.setAccessible(true);
			Field a = clazz2.getDeclaredField("a"); a.setAccessible(true);

			c.set(gamemodeInstance, -1);
			d.set(gamemodeInstance, -1);
			e.set(gamemodeInstance, -1);
			f.set(gamemodeInstance, 0);
			g.set(gamemodeInstance, 0);
			h.set(gamemodeInstance, 0);
			a.set(gamemodeInstance, minecraftInstance);
			return gamemodeInstance;
		} catch (Throwable t) {
			t.printStackTrace();
		}
		return null;
	}
}
