/*
 * Decompiled with CFR 0.152.
 */
package pl.moresteck;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import pl.moresteck.GameAppletLauncher;
import pl.moresteck.GameStandaloneLauncher;

public class BCWrapper {
    public static HashMap<String, String> arguments = new HashMap();
    public static String server;
    public static String port;
    public static String mppass;
    public static List<String> jvmargs;
    public static String proxy_host;
    public static String proxy_port;

    static {
        proxy_host = "betacraft.pl";
        proxy_port = "80";
    }

    public static void main(String[] args) {
        boolean standalone;
        String game_dir;
        String version_name;
        Properties p = System.getProperties();
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        System.setProperty("http.proxyHost", "betacraft.pl");
        int i = 0;
        while (i < args.length) {
            String[] split = args[i].split("=");
            arguments.put(split[0], split.length == 1 ? "" : split[1]);
            ++i;
        }
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        jvmargs = new ArrayList<String>(bean.getInputArguments());
        int i2 = 0;
        while (i2 < jvmargs.size()) {
            String arg = jvmargs.get(i2);
            if (arg.startsWith("-Dhttp.proxyPort")) {
                proxy_port = arg.split("=")[1];
                jvmargs.remove(i2);
            } else if (arg.startsWith("-Dhttp.proxyHost")) {
                proxy_host = arg.split("=")[1];
                jvmargs.remove(i2);
            } else if (arg.startsWith("-Dbetacraft.")) {
                jvmargs.remove(i2);
            }
            ++i2;
        }
        HashMap<String, String> applet_params = new HashMap<String, String>();
        applet_params.put("username", arguments.get("username"));
        applet_params.put("sessionid", arguments.get("sessionid"));
        applet_params.put("haspaid", "true");
        if (arguments.get("demo") != null) {
            applet_params.put("demo", "true");
        }
        for (Object key : p.keySet()) {
            String query = (String)key;
            if (query.equals("server")) {
                server = System.getProperty(query);
                port = p.containsKey("port") ? System.getProperty("port") : "25565";
                mppass = p.containsKey("mppass") ? System.getProperty("mppass") : "-";
            } else if (!query.equals("port") && !query.equals("mppass")) {
                applet_params.put(query, System.getProperty(query));
            }
            System.out.println("SET " + query + "=" + System.getProperty(query));
        }
        if (server != null && port != null && mppass != null) {
            System.out.println("Accepted server parameters: " + server + ", " + port + ", " + mppass);
            applet_params.put("server", server);
            applet_params.put("port", port);
            applet_params.put("mppass", mppass);
        }
        System.out.println("Accepted username: " + arguments.get("username"));
        String natives_dir = arguments.get("nativesDir");
        System.setProperty("org.lwjgl.librarypath", natives_dir);
        System.setProperty("net.java.games.input.librarypath", natives_dir);
        int x = 854;
        int y = 480;
        try {
            x = Integer.parseInt(arguments.get("width"));
            y = Integer.parseInt(arguments.get("height"));
        }
        catch (Throwable t) {
            System.out.println("Couldn't parse width/height values. Will use the default ones.");
            arguments.put("width", Integer.toString(x));
            arguments.put("height", Integer.toString(y));
        }
        String frame_name = arguments.get("frameName");
        if (frame_name == null || frame_name.equals("")) {
            frame_name = "Minecraft";
        }
        if ((version_name = arguments.get("versionName")) != null && !version_name.equals("")) {
            frame_name = String.valueOf(frame_name) + " [" + version_name.replaceAll("IJ ", "") + "]";
        }
        BufferedImage icon = null;
        try {
            icon = ImageIO.read(BCWrapper.class.getClassLoader().getResourceAsStream("favicon.png"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String appdata = game_dir = arguments.remove("gameDir");
        if (appdata.endsWith(".minecraft") || appdata.endsWith(".minecraft/") || appdata.endsWith(".minecraft\\")) {
            appdata = appdata.substring(0, appdata.indexOf(".minecraft"));
        }
        if (!appdata.endsWith("/") && !appdata.endsWith("\\")) {
            appdata = String.valueOf(appdata) + File.separator;
        }
        if (game_dir.endsWith(".minecraft") || game_dir.endsWith(".minecraft/") || game_dir.endsWith(".minecraft\\")) {
            if (game_dir.substring(game_dir.indexOf(".minecraft"), game_dir.length()).endsWith(".minecraft")) {
                game_dir = String.valueOf(game_dir) + File.separator;
            }
        } else {
            game_dir = game_dir.endsWith("/") || game_dir.endsWith("\\") ? String.valueOf(game_dir) + ".minecraft" + File.separator : String.valueOf(game_dir) + File.separator + ".minecraft" + File.separator;
        }
        arguments.put("gameDir", game_dir);
        arguments.put("appdata", appdata);
        System.out.println("SET gameDir=" + game_dir);
        System.out.println("SET appdata=" + appdata);
        String main_class = arguments.get("mainClass");
        boolean bl = standalone = System.getProperty("betacraft.standalone") != null;
        if (standalone) {
            GameStandaloneLauncher game_launcher = new GameStandaloneLauncher(main_class);
            game_launcher.launchGame();
        } else {
            GameAppletLauncher applet_launcher = new GameAppletLauncher(applet_params, main_class, frame_name, x, y, icon);
            applet_launcher.makeWrapper();
            System.out.println("APPDATA set to: " + System.getenv("APPDATA"));
            System.setProperty("user.home", appdata);
            applet_launcher.launchGame();
        }
    }

    public static void removeRecursively(File folder, boolean deleteFolderItself, ArrayList<String> whitelist) {
        String[] entries = folder.list();
        if (entries == null) {
            if (deleteFolderItself) {
                folder.delete();
            }
            return;
        }
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!whitelist.contains(s)) {
                File currentFile = new File(folder.getPath(), s);
                if (currentFile.isDirectory()) {
                    String[] stringArray2 = currentFile.list();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s1 = stringArray2[n4];
                        BCWrapper.removeRecursively(new File(currentFile.getPath(), s1), true, new ArrayList<String>());
                        ++n4;
                    }
                    try {
                        Files.delete(currentFile.toPath());
                    }
                    catch (Exception exception) {}
                } else {
                    currentFile.delete();
                }
            }
            ++n2;
        }
        if (deleteFolderItself) {
            folder.delete();
        }
    }

    public static void moveRecursively(File folder, File destFolder, boolean moveFolderItself) {
        String[] entries = folder.list();
        if (entries == null) {
            if (!moveFolderItself) {
                return;
            }
            new File(destFolder, folder.getName()).mkdirs();
            folder.delete();
            return;
        }
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String loc = String.valueOf(moveFolderItself ? String.valueOf(folder.getName()) + "/" : "") + s;
            File currentFile = new File(folder.getPath(), s);
            if (currentFile.isDirectory()) {
                new File(destFolder, loc).mkdirs();
                BCWrapper.moveRecursively(currentFile, new File(destFolder, loc), false);
            } else {
                currentFile.renameTo(new File(destFolder, loc));
            }
            ++n2;
        }
        folder.delete();
        new File(destFolder, ".lastused").delete();
    }

    public static void unzip(String source, String dest_folder, boolean delete) {
        byte[] buffer = new byte[1024];
        try {
            FileInputStream fis = new FileInputStream(source);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                int length;
                if (entry.isDirectory()) {
                    entry = zis.getNextEntry();
                    continue;
                }
                String fileName = entry.getName();
                File newFile = new File(String.valueOf(dest_folder) + File.separator + fileName);
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((length = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, length);
                }
                fos.close();
                zis.closeEntry();
                entry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            fis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (delete) {
            new File(source).delete();
        }
        new File(dest_folder, ".lastused").delete();
    }
}

